/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.util.StringIntMap;

public final class RowMeta
implements Serializable {
    private static final long serialVersionUID = -3482884151225986183L;
    private final Field[] fields;
    private final StringIntMap nameIndexes;
    private final StringIntMap aliasIndexes;
    private final StringIntMap ignoreAliasIndexes;
    private int[] dataTypeOrdinals;

    public RowMeta(String[] fieldNames, DataType[] dataTypes) {
        this(RowMeta.createFields(fieldNames, dataTypes));
    }

    private static Field[] createFields(String[] fieldNames, DataType[] dataTypes) {
        Preconditions.checkArgument((fieldNames.length == dataTypes.length ? 1 : 0) != 0, (String)"fieldNames length must equals to dataTypes, but %d <> %d.", (int)fieldNames.length, (int)dataTypes.length);
        Field[] fields = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fields[i] = new Field(fieldNames[i], dataTypes[i]);
        }
        return fields;
    }

    public RowMeta(Field ... fields) {
        this.fields = fields;
        this.nameIndexes = new StringIntMap(fields.length);
        this.aliasIndexes = new StringIntMap(fields.length);
        this.ignoreAliasIndexes = new StringIntMap(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            String alias = field.getAlias();
            this.nameIndexes.put(name, i);
            if (alias == null) continue;
            this.aliasIndexes.put(alias, i);
            this.ignoreAliasIndexes.put(alias.toUpperCase(), i);
        }
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Field getField(int index) {
        return this.fields[index];
    }

    public Field getField(String nameOrAlias) {
        return this.getField(nameOrAlias, true);
    }

    public Field getField(String nameOrAlias, boolean throwException) {
        int index = this.getFieldIndex(nameOrAlias, throwException);
        if (index > -1) {
            return this.fields[index];
        }
        return null;
    }

    public int getFieldIndex(String nameOrAlias) {
        return this.getFieldIndex(nameOrAlias, true);
    }

    public int getFieldIndex(String nameOrAlias, boolean throwException) {
        int index = this.aliasIndexes.get(nameOrAlias);
        if (index != -1) {
            return index;
        }
        index = this.nameIndexes.get(nameOrAlias);
        if (index != -1) {
            this.aliasIndexes.put(nameOrAlias, index);
            return index;
        }
        index = this.ignoreAliasIndexes.get(nameOrAlias.toUpperCase());
        if (index != -1) {
            this.aliasIndexes.put(nameOrAlias, index);
            return index;
        }
        if (throwException) {
            throw AlgoException.create("field %s not found.", nameOrAlias);
        }
        return -1;
    }

    public String getFieldName(int index) {
        return this.fields[index].getName();
    }

    public String getFieldAlias(int index) {
        return this.fields[index].getAlias();
    }

    public DataType getFieldDataType(int index) {
        return this.fields[index].getDataType();
    }

    public Map<String, Object> toMap(Row row) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.toMap(row, map);
        return map;
    }

    public void toMap(Row row, Map<String, Object> map) {
        for (int i = 0; i < this.fields.length; ++i) {
            Object value = row.get(i);
            value = DataType.convertValue(this.fields[i].getDataType(), value);
            map.put(this.fields[i].getAlias(), value);
        }
    }

    public Field[] getFields(String[] fieldNames) {
        Field[] newFields = new Field[fieldNames.length];
        for (int i = 0; i < newFields.length; ++i) {
            newFields[i] = this.getField(fieldNames[i]).copy();
        }
        return newFields;
    }

    public static RowMeta fromResultSet(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            Field[] fields = new Field[rsmd.getColumnCount()];
            for (int i = 0; i < fields.length; ++i) {
                int sqlType = rsmd.getColumnType(i + 1);
                String name = rsmd.getColumnLabel(i + 1);
                fields[i] = new Field(name, DataType.fromSqlType(sqlType), true);
            }
            return new RowMeta(fields);
        }
        catch (SQLException e) {
            throw new AlgoException(e);
        }
    }

    public String toString() {
        return String.format("RowMeta%s", Arrays.toString(this.fields));
    }

    public List<DataType> getTypes() {
        return (List)Arrays.asList(this.fields).stream().map(Field::getDataType).collect(ImmutableList.toImmutableList());
    }

    public String[] getFieldNames() {
        String[] names = new String[this.fields.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.fields[i].getAlias();
        }
        return names;
    }

    public DataType[] getDataTypes() {
        DataType[] types = new DataType[this.fields.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.fields[i].getDataType();
        }
        return types;
    }

    public int[] getDataTypeOrdinals() {
        if (this.dataTypeOrdinals == null) {
            int[] ret = new int[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                ret[i] = this.fields[i].getDataType().ordinal;
            }
            this.dataTypeOrdinals = ret;
        }
        return this.dataTypeOrdinals;
    }

    public DataType getDataType(int index) {
        return this.fields[index].getDataType();
    }
}

