/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.SqlHint;
import kd.bos.algo.dataset.AutoCloseIterator;
import kd.bos.algo.dataset.CopiedDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.addfield.AddFieldDataSet;
import kd.bos.algo.dataset.addfield.AddNullFieldDataSet;
import kd.bos.algo.dataset.addfield.BalanceDataSet;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.dataset.cache.CachedDataSetImpl;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.algo.dataset.filter.FilterDataSet;
import kd.bos.algo.dataset.groupby.GroupbyDataSetBuilder;
import kd.bos.algo.dataset.hashjoin.HashJoinDataSetBuilder;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.order.OrderDataSet;
import kd.bos.algo.dataset.range.RangeDataSet;
import kd.bos.algo.dataset.range.TopDataSet;
import kd.bos.algo.dataset.resolve.CheckAllClosedResolver;
import kd.bos.algo.dataset.resolve.Resolver;
import kd.bos.algo.dataset.select.RemoveFieldsDataSet;
import kd.bos.algo.dataset.select.SelectBuilder;
import kd.bos.algo.dataset.sql.SqlDataSet;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.dataset.union.UnionDataSet;
import kd.bos.algo.env.Environment;
import kd.bos.algo.metrics.AlgoMetrics;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.util.resource.ResourceHolder;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.log4j.Logger;

public abstract class AbstractDataSet
extends ResourceHolder
implements DataSet {
    private Logger logger = Logger.getLogger(this.getClass());
    private String id;
    protected String name;
    protected Environment environment;
    protected boolean closed = false;
    protected boolean autoClosed = false;
    protected RowMeta rowMeta;
    protected ArrayList<DataSet.Listener> listeners = new ArrayList();
    private InnerRowIterator currentIterator = null;
    private List<AbstractDataSet> inputs = new ArrayList<AbstractDataSet>();
    private List<AbstractDataSet> outputs = new ArrayList<AbstractDataSet>();
    private boolean autoCloseDataSet = true;
    protected Store store;

    protected AbstractDataSet(String name, Environment env, Store store) {
        this(name, env, (List<AbstractDataSet>)null);
        this.store = store;
    }

    protected AbstractDataSet(String name, AbstractDataSet child) {
        this(name, child.getEnvironment(), child);
    }

    protected AbstractDataSet(String name, Environment environment, AbstractDataSet child) {
        this(name, environment, Lists.newArrayList((Object[])new AbstractDataSet[]{child}));
    }

    protected AbstractDataSet(String name, Environment environment, List<AbstractDataSet> inputs) {
        this.checkThreadContext();
        this.name = name;
        this.environment = environment;
        if (inputs != null) {
            for (AbstractDataSet node : inputs) {
                node.addOutput(this);
                this.inputs.add(node);
            }
        }
        environment.registerDataSet(this);
        AlgoMetrics.dataSetCounter.inc();
    }

    private void checkThreadContext() {
        String str = System.getProperty("bos.checkThreadContext");
        if ((str == null || "true".equals(str)) && !ManagedThreadFeature.isManaged()) {
            throw new AlgoException("Algo dataset must run in managed thread to avoid memory leak, please use ThreadPools.");
        }
    }

    public Store getStore() {
        return this.store;
    }

    public List<AbstractDataSet> getOutputs() {
        return ImmutableList.copyOf(this.outputs);
    }

    public List<AbstractDataSet> getInputs() {
        return ImmutableList.copyOf(this.inputs);
    }

    public AbstractDataSet getOutput(int index) {
        return this.outputs.get(index);
    }

    public AbstractDataSet getInput(int index) {
        return this.inputs.get(index);
    }

    public void addOutput(AbstractDataSet dataSet) {
        this.outputs.add(dataSet);
    }

    public void removeOutput(AbstractDataSet dataSet) {
        this.outputs.remove(dataSet);
    }

    public void removeInput(AbstractDataSet dataSet) {
        this.inputs.remove(dataSet);
    }

    public void clearInputs() {
        this.inputs.clear();
    }

    public void detachInputs(boolean close) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputs.get(i).removeOutput(this);
            if (!close) continue;
            this.inputs.get(i).close();
        }
        this.inputs.clear();
    }

    public int getOutputCount() {
        return this.outputs.size();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public final RowMeta getRowMeta() {
        if (this.rowMeta == null) {
            this.rowMeta = this.createTargetRowMeta();
        }
        return this.rowMeta;
    }

    protected abstract RowMeta createTargetRowMeta();

    public final InnerRowIterator iterator() {
        if (this.currentIterator != null) {
            if (this.currentIterator.hasItered()) {
                throw AlgoException.create("DataSet has bean iterated, can't iterated twice, detail: %s", this.toString());
            }
            return this.currentIterator;
        }
        if (this.getOutputCount() > 0) {
            throw AlgoException.create("Can't not iterator dataset: %s, which has been used in another dataset: %s.", this.toString(), this.outputs.get(0).toString());
        }
        this.currentIterator = this.innerIterator();
        if (this.autoCloseDataSet && !(this.currentIterator instanceof AutoCloseIterator)) {
            this.currentIterator = new AutoCloseIterator(() -> this.autoClose(), this.currentIterator);
        }
        return this.currentIterator;
    }

    public final InnerRowIterator innerIterator() {
        if (this.currentIterator != null) {
            if (this.currentIterator.hasItered()) {
                throw AlgoException.create("DataSet has bean iterated, can't iterate twice, detail: %s", this.toString());
            }
            return this.currentIterator;
        }
        if (this.getOutputCount() > 1) {
            this.ensureStore();
        }
        if (this.store != null) {
            return InnerRowIterator.wrapper(this.store.getRowIterator());
        }
        if (this.store == null) {
            this.currentIterator = this.createIterator();
            if (this.autoCloseDataSet && !(this.currentIterator instanceof AutoCloseIterator)) {
                this.currentIterator = new AutoCloseIterator(() -> this.autoClose(), this.currentIterator);
            }
            return this.currentIterator;
        }
        return this.createIterator();
    }

    public void ensureStore() {
        if (this.store == null) {
            InnerRowIterator iter = this.createIterator();
            this.createStore(iter);
        }
    }

    protected void createStore(Iterator<Row> iter) {
        Store oldStore = this.store;
        this.store = StoreFactory.createSequenceStore(this.getRowMeta());
        this.store.write(iter);
        if (oldStore != null) {
            oldStore.close();
        }
    }

    private InnerRowIterator getCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterator();
        }
        return this.currentIterator;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrentIterator().hasNext();
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentIterator().isEmpty();
    }

    @Override
    public Row next() {
        return this.getCurrentIterator().next();
    }

    protected abstract InnerRowIterator createIterator();

    @Override
    public JoinDataSet join(DataSet rightDataSet) {
        return this.join(rightDataSet, JoinType.INNER);
    }

    @Override
    public HashTable toHashTable(String keyField) {
        this.checkClosed();
        return this.environment.toHashTable(this, keyField);
    }

    private void closeInputs() {
        for (AbstractDataSet child : this.inputs) {
            child.removeOutput(this);
            child.close();
        }
    }

    @Override
    public void close() {
        try {
            this.close0(false);
        }
        catch (Throwable t) {
            this.logger.error((Object)t);
        }
    }

    public void forceClose() {
        try {
            this.close0(true);
        }
        catch (Throwable t) {
            this.logger.error((Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close0(boolean force) {
        if (this.closed) {
            return;
        }
        int parentSize = this.getOutputCount();
        if (force || parentSize == 0) {
            for (DataSet.Listener l : this.listeners) {
                l.beforeClosed();
            }
            try {
                this.environment.unregisterDataSet(this);
                AlgoMetrics.dataSetCounter.dec();
                this.realClose();
                this.closed = true;
                this.autoClosed = false;
                if (this.store != null) {
                    try {
                        this.store.close();
                    }
                    catch (Throwable t) {
                        this.logger.error((Object)t);
                    }
                }
                this.closeInputs();
                this.clearInputs();
                this.closeAllResources();
            }
            finally {
                for (DataSet.Listener l : this.listeners) {
                    try {
                        l.afterClosed();
                    }
                    catch (Throwable t) {
                        this.logger.error((Object)t);
                    }
                }
            }
        }
    }

    @Override
    public DataSet select(String ... exprs) {
        this.checkClosed();
        return SelectBuilder.build(this, exprs);
    }

    @Override
    public DataSet select(String expr) {
        this.checkClosed();
        return SelectBuilder.build(this, expr);
    }

    @Override
    public DataSet addBalanceField(String expr, String alias) {
        this.checkClosed();
        return new BalanceDataSet(this, expr, alias);
    }

    @Override
    public DataSet addField(String expr, String alias) {
        this.checkClosed();
        return new AddFieldDataSet(this, expr, alias);
    }

    @Override
    public DataSet addNullField(String alias) {
        this.checkClosed();
        return new AddNullFieldDataSet(this, alias);
    }

    @Override
    public DataSet addNullField(String ... aliases) {
        this.checkClosed();
        return new AddNullFieldDataSet(this, aliases);
    }

    @Override
    public DataSet removeFields(String ... fieldNames) {
        this.checkClosed();
        return new RemoveFieldsDataSet(this, fieldNames);
    }

    public DataSet filter(Expr expr) {
        this.checkClosed();
        return new FilterDataSet(this, expr);
    }

    @Override
    public DataSet filter(String expr) {
        return this.filter(expr, null);
    }

    @Override
    public DataSet filter(String expr, Map<String, Object> params) {
        this.checkClosed();
        return new FilterDataSet(this, expr, params);
    }

    @Override
    public HashJoinDataSet hashJoin(HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields) {
        this.checkClosed();
        return new HashJoinDataSetBuilder(this, hashTable, leftJoinKeyField, hashTableSelectFields, false);
    }

    @Override
    public HashJoinDataSet hashJoin(HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields, boolean includeNoExist) {
        this.checkClosed();
        return new HashJoinDataSetBuilder(this, hashTable, leftJoinKeyField, hashTableSelectFields, includeNoExist);
    }

    @Override
    public GroupbyDataSet groupBy() {
        this.checkClosed();
        return new GroupbyDataSetBuilder(this, null);
    }

    public GroupbyDataSet groupBy(String groupField) {
        this.checkClosed();
        if (groupField == null) {
            return new GroupbyDataSetBuilder(this, null);
        }
        return new GroupbyDataSetBuilder(this, new String[]{groupField});
    }

    public GroupbyDataSet groupBy(String groupField, boolean orderByDesc) {
        this.checkClosed();
        return new GroupbyDataSetBuilder(this, new String[]{groupField}, new boolean[]{orderByDesc});
    }

    @Override
    public GroupbyDataSet groupBy(String[] groupFields) {
        this.checkClosed();
        return new GroupbyDataSetBuilder(this, groupFields);
    }

    @Override
    public GroupbyDataSet groupBy(String[] groupFields, boolean[] orderByDescs) {
        this.checkClosed();
        return new GroupbyDataSetBuilder(this, groupFields, orderByDescs);
    }

    @Override
    public DataSet orderBy(String[] exprs) {
        this.checkClosed();
        return new OrderDataSet(this, exprs);
    }

    @Override
    public JoinDataSet join(DataSet rightDataSet, JoinType type) {
        return this.join(rightDataSet, type, new JoinHint());
    }

    @Override
    public JoinDataSet join(DataSet rightDataSet, JoinHint hint) {
        return this.join(rightDataSet, JoinType.INNER, hint);
    }

    @Override
    public JoinDataSet join(DataSet rightDataSet, JoinType type, JoinHint hint) {
        this.checkClosed();
        if (hint == null) {
            hint = new JoinHint();
        }
        return new JoinDataSetBuilder(this, (AbstractDataSet)rightDataSet, type, hint);
    }

    @Override
    public DataSet union(DataSet dataSet) {
        this.checkClosed();
        return new UnionDataSet(this, (AbstractDataSet)dataSet);
    }

    @Override
    public DataSet top(int length) {
        this.checkClosed();
        if (length < 0) {
            throw new AlgoException("Illegal length %d", length);
        }
        return new TopDataSet(this, length);
    }

    @Override
    public DataSet range(int start, int length) {
        this.checkClosed();
        if (length < 0) {
            throw new AlgoException("Illegal length %d", length);
        }
        return new RangeDataSet(this, start, length);
    }

    @Override
    public final DataSet copy() {
        this.checkClosed();
        this.ensureStore();
        Store copyStore = this.store.copy();
        return new CopiedDataSet(this.environment, this.getRowMeta(), copyStore);
    }

    public abstract void realClose();

    public boolean isClosed() {
        return this.closed;
    }

    public void checkClosed() {
        if (this.autoClosed) {
            throw new AlgoException("%s has been auto closed because iterator cursor over.", this.toString());
        }
        if (this.closed) {
            throw new AlgoException("%s has been closed.", this.toString());
        }
    }

    @Override
    public DataSet executeSql(String sql) {
        return this.executeSql(sql, SqlHint.DEFAULT);
    }

    @Override
    public DataSet executeSql(String sql, SqlHint hint) {
        this.checkClosed();
        return new SqlDataSet(this, sql, hint);
    }

    @Override
    public int count(String field, boolean distinct) {
        this.checkClosed();
        InnerRowIterator iter = this.innerIterator();
        if (distinct) {
            HashSet<Object> unique = new HashSet<Object>();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Object o = row.get(field);
                if (o == null) continue;
                unique.add(o);
            }
            return unique.size();
        }
        int count = 0;
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            Object o = row.get(field);
            if (o == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public CachedDataSet cache(CacheHint hint) {
        this.checkClosed();
        try (TraceSpan span = Tracer.create((String)"DataSet", (String)"cache");){
            DataSetCacheSpi spi = DataSetCacheSpiFactory.getSpi();
            DataSetCacheMeta meta = spi.save(this.getRowMeta(), this.innerIterator(), hint);
            span.addTag("type", this.getSpanTag(), true);
            span.addTag("size", String.valueOf(meta.getRowCount()), true);
            this.close();
            CachedDataSetImpl cachedDataSetImpl = new CachedDataSetImpl(meta);
            return cachedDataSetImpl;
        }
    }

    @Override
    public CachedDataSet.Builder cacheBuilder(CacheHint hint) {
        return new CachedDataSetBuilder(this.getRowMeta(), hint, this.getSpanTag());
    }

    @Override
    public void print(boolean copy) {
        DataSet ds = copy ? this.copy() : this;
        RowMeta rowMeta = this.getRowMeta();
        int cols = rowMeta.getFieldCount();
        for (int i = 0; i < cols; ++i) {
            System.out.print(rowMeta.getFieldAlias(i) + "\t");
        }
        System.out.println();
        for (Row row : ds) {
            for (int i = 0; i < cols; ++i) {
                Object obj = row.get(i);
                System.out.print("" + obj + "\t");
            }
            System.out.println();
        }
    }

    @Override
    public void addListener(DataSet.Listener listener) {
        this.listeners.add(listener);
    }

    public AbstractDataSet resolve(Resolver ... resolvers) {
        AbstractDataSet expr = this;
        for (Resolver resolver : resolvers) {
            expr = resolver.resolve(expr);
        }
        return expr;
    }

    public void checkAllClosed() {
        this.resolve(new CheckAllClosedResolver());
    }

    protected void autoClose() {
        this.close();
        this.autoClosed = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSpanTag() {
        return this.name;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id != null ? this.id : String.valueOf(System.identityHashCode(this));
    }

    public String toString() {
        return String.format("DataSet '%s',%s", this.getName(), this.getRowMeta() == null ? "" : this.getRowMeta().toString());
    }
}

