/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.PersistedRow;
import kd.bos.algo.dataset.RowFactory;

public abstract class AbstractRow
implements Row,
Serializable {
    private static final long serialVersionUID = 1952494707735336912L;

    @Override
    public Object get(String field) {
        return this.get(field, true);
    }

    public Object get(String field, boolean exception) {
        int index = this.getRowMeta().getFieldIndex(field);
        if (index < 0) {
            if (exception) {
                throw new AlgoException("Field " + field + " not found.");
            }
            return null;
        }
        return this.get(index);
    }

    @Override
    public String getString(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue(DataType.StringType, v);
    }

    @Override
    public String getString(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue(DataType.StringType, v);
    }

    @Override
    public Integer getInteger(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue(DataType.IntegerType, v);
    }

    @Override
    public Integer getInteger(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue(DataType.IntegerType, v);
    }

    @Override
    public Long getLong(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return (Long)DataType.convertValue(DataType.LongType, v);
    }

    @Override
    public Long getLong(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return (Long)DataType.convertValue(DataType.LongType, v);
    }

    @Override
    public Boolean getBoolean(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue(DataType.BooleanType, v);
    }

    @Override
    public Boolean getBoolean(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue(DataType.BooleanType, v);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue(DataType.BigDecimalType, v);
    }

    @Override
    public BigDecimal getBigDecimal(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue(DataType.BigDecimalType, v);
    }

    @Override
    public Double getDouble(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue(DataType.DoubleType, v);
    }

    @Override
    public Double getDouble(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue(DataType.DoubleType, v);
    }

    @Override
    public Date getDate(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        return (Date)DataType.convertValue(DataType.DateType, v);
    }

    @Override
    public Date getDate(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        return (Date)DataType.convertValue(DataType.DateType, v);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue(DataType.TimestampType, v);
    }

    @Override
    public Timestamp getTimestamp(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue(DataType.TimestampType, v);
    }

    public abstract Object[] values();

    public abstract RowMeta getRowMeta();

    protected Object[] defaultConvertValues() {
        int len = this.size();
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.get(i);
        }
        return values;
    }

    public AbstractRow persist() {
        if (this instanceof PersistedRow) {
            return this;
        }
        return (AbstractRow)((Object)RowFactory.createPersistedRow(this.getRowMeta(), this.values(), false));
    }

    public String toString() {
        return Arrays.toString(this.values());
    }
}

