/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.InnerRowIterator;

public class AutoCloseIterator
extends InnerRowIterator {
    private final AutoCloseable closer;
    private boolean eof = false;
    private Iterator<Row> iter;

    public AutoCloseIterator(AutoCloseable closer, Iterator<Row> iter) {
        this.closer = closer;
        this.iter = iter;
    }

    @Override
    public boolean _hasNext() {
        if (this.eof) {
            return false;
        }
        boolean b = this.iter.hasNext();
        if (!b) {
            this.autoClose();
            this.eof = true;
        }
        return b;
    }

    private void autoClose() {
        try {
            this.closer.close();
            this.iter = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Row _next() {
        if (this.eof) {
            throw new AlgoException("dataset eof");
        }
        return this.iter.next();
    }
}

