/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.EmptyInnerRowIterator;
import kd.bos.algo.dataset.InnerRowIteratorWrapper;

public abstract class InnerRowIterator
implements Iterator<Row> {
    public static InnerRowIterator EMPTY = new EmptyInnerRowIterator();
    private Boolean hasNexted = null;
    private boolean hasItered = false;
    private Boolean isEmpty = null;

    public static InnerRowIterator wrapper(Iterator<Row> iter) {
        if (iter instanceof InnerRowIterator) {
            return (InnerRowIterator)iter;
        }
        return new InnerRowIteratorWrapper(iter);
    }

    protected abstract boolean _hasNext();

    protected abstract Row _next();

    @Override
    public boolean hasNext() {
        if (this.hasNexted != null) {
            return this.hasNexted;
        }
        boolean b = this._hasNext();
        this.hasNexted = b;
        if (this.isEmpty == null) {
            this.isEmpty = !b;
        }
        return b;
    }

    @Override
    public Row next() {
        if (this.hasNexted == null) {
            this.hasNext();
        }
        if (!this.hasNexted.booleanValue()) {
            throw new AlgoException("EOF of dataset.");
        }
        Row next = this._next();
        this.hasNexted = null;
        this.hasItered = true;
        return next;
    }

    public boolean hasItered() {
        return this.hasItered;
    }

    public boolean isEmpty() {
        return this.isEmpty == null ? !this.hasNext() : this.isEmpty;
    }
}

