/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;

public class MappedSelectRow
extends AbstractRow {
    private Row row;
    private RowMeta newRowMeta;
    private Map<String, Integer> fieldIndexMapper;
    private int[] fieldIndexIntMapper;

    public MappedSelectRow(RowMeta newRowMeta, Map<String, Integer> fieldIndexMapper, int[] fieldIndexIntMapper) {
        this.newRowMeta = newRowMeta;
        this.fieldIndexMapper = fieldIndexMapper;
        this.fieldIndexIntMapper = fieldIndexIntMapper;
    }

    @Override
    public int size() {
        return this.newRowMeta.getFieldCount();
    }

    @Override
    public Object get(String nameOrAlias) {
        Integer i = this.fieldIndexMapper.get(nameOrAlias);
        if (i == null) {
            throw new AlgoException("Field " + nameOrAlias + " not found.");
        }
        return this.row.get(i);
    }

    @Override
    public Object get(int index) {
        return this.row.get(this.fieldIndexIntMapper[index]);
    }

    @Override
    public Object[] values() {
        return this.defaultConvertValues();
    }

    @Override
    public RowMeta getRowMeta() {
        return this.newRowMeta;
    }

    public void setRow(Row row) {
        this.row = row;
    }
}

