/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.CachedDataSetImpl;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class CachedDataSetBuilder
implements CachedDataSet.Builder {
    private CacheHint hint;
    private DataSetCacheSpi spi;
    private DataSetCacheMeta meta;
    private RowMeta rowMeta;
    private List<Row> rows = new LinkedList<Row>();
    List<Iterator<Row>> iterList = new LinkedList<Iterator<Row>>();
    private String spanTag;

    public CachedDataSetBuilder(RowMeta rowMeta, CacheHint hint) {
        this(rowMeta, hint, null);
    }

    public CachedDataSetBuilder(RowMeta rowMeta, CacheHint hint, String spanTag) {
        this.hint = hint;
        this.rowMeta = rowMeta;
        this.spanTag = spanTag;
        this.spi = hint.getStorageType() != null ? DataSetCacheSpiFactory.getSpi(hint.getStorageType()) : DataSetCacheSpiFactory.getSpi();
    }

    @Override
    public void append(Row row) {
        this.rows.add(((AbstractRow)row).persist());
    }

    @Override
    public void append(Iterator<Row> rowIterator) {
        this.iterList.add(rowIterator);
    }

    @Override
    public CachedDataSet build() {
        try (TraceSpan span = Tracer.create((String)"DataSet", (String)"cache");){
            Iterators.concat(this.iterList.iterator());
            Iterator all = Iterators.concat(this.rows.iterator(), (Iterator)Iterators.concat(this.iterList.iterator()));
            this.meta = this.spi.save(this.rowMeta, all, this.hint);
            if (this.spanTag != null) {
                span.addTag("type", this.spanTag, true);
            }
            span.addTag("size", String.valueOf(this.meta.getRowCount()), true);
            CachedDataSetImpl cachedDataSetImpl = new CachedDataSetImpl(this.meta);
            return cachedDataSetImpl;
        }
    }
}

