/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache.fs;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.SimpleMetaImpl;
import kd.bos.algo.dataset.cache.TimeoutInfo;
import kd.bos.algo.serde.RowSerde;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;

public class FSSpiImpl
implements DataSetCacheSpi {
    private FileSystemStorage storage;
    RowSerde rowSerde;
    private Timer timer;
    private Meter meter;
    private Meter errorMeter;
    private Timer timerByName;
    private Meter meterByName;
    private Meter errorByName;

    public FSSpiImpl(FileSystemStorage storage) {
        this.storage = storage;
        this.timer = MetricSystem.timer((String)"kd.metrics.algo.cache.saveTimer");
        this.meter = MetricSystem.meter((String)"kd.metrics.algo.cache.saveMeter");
        this.errorMeter = MetricSystem.meter((String)"kd.metrics.algo.cache.saveMeter.error");
        this.timerByName = MetricSystem.timer((String)("kd.metrics.algo.cache.saveTimer." + storage.getName()));
        this.meterByName = MetricSystem.meter((String)("kd.metrics.algo.cache.saveMeter." + storage.getName()));
        this.errorByName = MetricSystem.meter((String)("kd.metrics.algo.cache.saveMeter.error." + storage.getName()));
    }

    @Override
    public DataSetCacheMeta save(RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        Timer.Context context = this.timer.time();
        Timer.Context contextByName = this.timerByName.time();
        try {
            String[] strs = this.generateIdAndUrl(hint.getTimeout());
            String id = strs[0];
            String baseUrl = strs[1];
            int rowCount = this.writeRows(baseUrl, rowMeta, iter, hint);
            this.meter.mark((long)rowCount);
            this.meterByName.mark((long)rowCount);
            SimpleMetaImpl meta = new SimpleMetaImpl(id, rowMeta, rowCount, hint.getPageSize());
            this.writeMeta(baseUrl, meta, hint);
            SimpleMetaImpl simpleMetaImpl = meta;
            return simpleMetaImpl;
        }
        catch (IOException e) {
            this.errorMeter.mark();
            this.errorByName.mark();
            throw new AlgoException("can't save dataset cache: " + e.getMessage(), e);
        }
        finally {
            context.stop();
            contextByName.stop();
        }
    }

    private void writeTimeout(String baseUrl, CacheHint hint) {
        long timeout = hint.getTimeout();
        long createTime = System.currentTimeMillis();
        Properties prop = new Properties();
        prop.setProperty("timeout", "" + timeout);
        prop.setProperty("createTime", "" + createTime);
        String url = this.getTimeoutUrl(baseUrl);
        OutputStream out = null;
        try {
            out = this.storage.create(url, timeout);
            out = new BufferedOutputStream(out);
            prop.store(out, null);
            out.flush();
        }
        catch (IOException e) {
            throw new AlgoException("error when write dataset cache index.", e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public TimeoutInfo getTimeoutInfo(String id) {
        String baseUrl = this.getUrl(id);
        String url = this.getTimeoutUrl(baseUrl);
        Properties prop = new Properties();
        InputStream in = null;
        try {
            in = this.storage.open(url);
            prop.load(in);
        }
        catch (IOException e) {
            throw new AlgoException("error when getTimeout for id " + id, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        TimeoutInfo info = new TimeoutInfo();
        info.setTimeout(Integer.parseInt(prop.getProperty("timeout")));
        info.setCreateTime(Long.parseLong(prop.getProperty("createTime")));
        return info;
    }

    private void writeMeta(String baseUrl, SimpleMetaImpl meta, CacheHint hint) {
        String url = this.getMetaUrl(baseUrl);
        OutputStream out = null;
        try {
            out = this.storage.create(url, hint.getTimeout());
            out = new BufferedOutputStream(out);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(meta);
            out.flush();
        }
        catch (IOException e) {
            throw new AlgoException("error when write dataset cache meta.", e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public DataSetCacheMeta getMeta(String id) {
        String baseUrl = this.getUrl(id);
        String url = this.getMetaUrl(baseUrl);
        InputStream in = null;
        try {
            DataSetCacheMeta meta;
            in = this.storage.open(url);
            ObjectInputStream ois = new ObjectInputStream(in);
            DataSetCacheMeta dataSetCacheMeta = meta = (DataSetCacheMeta)ois.readObject();
            return dataSetCacheMeta;
        }
        catch (Exception e) {
            throw new AlgoException("error when get dataset cache meta.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int writeRows(String baseUrl, RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        int rowCount = 0;
        while (iter.hasNext()) {
            int pageId = rowCount / hint.getPageSize();
            int writeRowCount = this.writePage(baseUrl, pageId, rowMeta, iter, hint);
            rowCount += writeRowCount;
        }
        return rowCount;
    }

    private int writePage(String baseUrl, int pageId, RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        String url = this.getPageUrl(baseUrl, pageId);
        OutputStream out = null;
        try {
            int rowCount;
            out = this.storage.create(url, hint.getTimeout());
            out = new BufferedOutputStream(out);
            DataOutputStream dout = new DataOutputStream(out);
            for (rowCount = 0; iter.hasNext() && rowCount < hint.getPageSize(); ++rowCount) {
                Row row = iter.next();
                this.writeRow(rowMeta, row, dout);
            }
            this.rowSerde.flush(dout);
            int n = rowCount;
            return n;
        }
        catch (IOException e) {
            throw new AlgoException("can't write page: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeRow(RowMeta rowMeta, Row row, DataOutputStream out) {
        this.rowSerde.write(rowMeta, row, out);
    }

    private Row readRow(RowMeta rowMeta, DataInputStream in) {
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        return this.rowSerde.read(rowMeta, in);
    }

    @Override
    public void delete(DataSetCacheMeta meta) {
        this.delete(meta.getId());
    }

    @Override
    public void delete(String id) {
        try {
            this.storage.delete(this.getUrl(id));
        }
        catch (IOException e) {
            throw new AlgoException("error when delete dataset cache iterator.", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Row> getList(DataSetCacheMeta meta, int begin, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Iterator<Row> getIterator(DataSetCacheMeta meta, int begin, int length) {
        List<Row> list = this.getList(meta, begin, length);
        return list.iterator();
    }

    protected String generateId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getUrl(String id) {
        return "datasetcache/" + id.substring(0, 8) + "/" + id;
    }

    public String[] generateIdAndUrl(long timeout) throws IOException {
        String id;
        String url;
        while (!this.storage.createDirectory(url = this.getUrl(id = this.generateId()), timeout)) {
        }
        this.storage.createDirectory(url, timeout);
        return new String[]{id, url};
    }

    public String getMetaUrl(String baseUrl) {
        return baseUrl + "/meta";
    }

    public String getTimeoutUrl(String baseUrl) {
        return baseUrl + "/timeout";
    }

    public String getPageUrl(String baseUrl, int page) {
        return baseUrl + "/page" + page;
    }
}

