/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.filter;

import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;

public class FilterDataSet
extends AbstractDataSet {
    private String expression;
    private Map<String, Object> params;
    private Expr expr;

    public FilterDataSet(AbstractDataSet dataSet, Expr expr) {
        super("Filter", dataSet);
        this.expr = expr;
        this.rowMeta = this.createTargetRowMeta();
    }

    public FilterDataSet(AbstractDataSet dataSet, String expr, Map<String, Object> params) {
        super("Filter", dataSet);
        this.expression = expr;
        this.params = params;
        this.rowMeta = this.createTargetRowMeta();
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet inner = this.getInput(0);
        final InnerRowIterator iter = inner.innerIterator();
        RowMeta rowMeta = inner.getRowMeta();
        this.expr = this.expr == null ? new ExprParser(rowMeta, this.params).parse(this.expression) : new ExprParser(rowMeta, this.params).resolve(this.expr);
        final Calc calc = CalcCompiler.compile(rowMeta, this.expr);
        return new InnerRowIterator(){
            Row current;

            @Override
            public boolean _hasNext() {
                if (this.current != null) {
                    return true;
                }
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    if (!FilterDataSet.this.filterRow(calc, r)) continue;
                    this.current = r;
                    return true;
                }
                return false;
            }

            @Override
            public Row _next() {
                Row result = this.current;
                this.current = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean filterRow(Calc calc, Row r) {
        return (Boolean)calc.execute(r, null);
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.getInput(0).getRowMeta();
    }

    @Override
    public void realClose() {
    }
}

