/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Comparator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.AlgoUtil;
import kd.bos.algo.util.ArrayKey;

public class ArrayKeyComparator
implements Comparator<ArrayKey> {
    private boolean[] descs;
    private int length;

    public ArrayKeyComparator(boolean[] descs) {
        this.descs = descs;
        this.length = descs.length;
    }

    @Override
    public int compare(ArrayKey keys1, ArrayKey keys2) {
        Object[] a1 = keys1.getArray();
        Object[] a2 = keys2.getArray();
        for (int i = 0; i < this.length; ++i) {
            int r;
            Object o1 = a1[i];
            Object o2 = a2[i];
            if (o1 == null) {
                if (o2 == null) continue;
                return -1;
            }
            if (o2 == null) {
                return this.descs[i] ? -1 : 1;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                r = AlgoUtil.compareNumber((Number)o1, (Number)o2);
                if (r == 0) continue;
                return this.descs[i] ? -1 * r : r;
            }
            if (o1 instanceof Number && !(o2 instanceof Number)) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (!(o1 instanceof Number) && o2 instanceof Number) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (o1 instanceof Comparable) {
                r = ((Comparable)o1).compareTo(o2);
                if (r == 0) continue;
                return this.descs[i] ? -1 * r : r;
            }
            throw new AlgoException("Value not be comparable:" + o1);
        }
        return 0;
    }
}

