/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.groupby.AggregatorUtils;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.dataset.groupby.LimitedHashGrouper;
import kd.bos.algo.dataset.groupby.OrderGrouperIterator;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.agg.IAgg;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;
import kd.bos.algo.util.Aggregator;

public class SmartGroupByDataSet
extends AbstractDataSet {
    private GroupbyInfo info;
    String[] groupFields;
    boolean[] descs;
    Aggregator[] aggregators;
    Calc[] groupCalcs;
    Calc[] aggCalcs;
    OrderItem[] orderItems;
    Store tempStore;
    Store orderStore;
    AbstractDataSet input = null;
    LimitedHashGrouper limitHashGrouper;
    private static String KEY_GROUPBY_HASH_LIMIT = "algo.groupby.hash.limit";
    private static int default_limit = 100000;

    public SmartGroupByDataSet(AbstractDataSet dataSet, GroupbyInfo info) {
        super("GroupBy", dataSet);
        this.info = info;
        this.groupFields = info.getGroups();
        this.buildMeta();
        this.buildOrderItems();
    }

    private static int getLimit() {
        String str = System.getProperty(KEY_GROUPBY_HASH_LIMIT);
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return default_limit;
    }

    private void buildOrderItems() {
        if (this.groupFields != null && this.groupFields.length > 0) {
            String[] orderKeys = this.info.getGroups();
            this.descs = this.info.getOrderByDescs();
            if (this.descs == null) {
                this.descs = new boolean[orderKeys.length];
            }
            this.orderItems = new OrderItem[orderKeys.length];
            for (int i = 0; i < orderKeys.length; ++i) {
                this.orderItems[i] = new OrderItem(orderKeys[i], this.descs == null ? true : !this.descs[i]);
            }
        }
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        this.input = this.getInput(0);
        InnerRowIterator sourceIter = this.input.innerIterator();
        this.limitHashGrouper = new LimitedHashGrouper(sourceIter, this.groupCalcs, this.descs, this.aggCalcs, this.aggregators, this.rowMeta);
        boolean finished = this.limitHashGrouper.build(SmartGroupByDataSet.getLimit());
        if (finished && !sourceIter.hasNext()) {
            this.detachInputs(true);
            return this.limitHashGrouper.getIterator(true);
        }
        this.orderStore = StoreFactory.createOrderStore(this.rowMeta, this.orderItems);
        this.orderStore.write(this.limitHashGrouper.getIterator(false));
        do {
            this.limitHashGrouper = new LimitedHashGrouper(sourceIter, this.groupCalcs, this.descs, this.aggCalcs, this.aggregators, this.rowMeta);
            finished = this.limitHashGrouper.build(SmartGroupByDataSet.getLimit());
            this.orderStore.write(this.limitHashGrouper.getIterator(false));
        } while (!finished);
        Iterator<Row> rowIter = this.orderStore.getRowIterator();
        this.detachInputs(true);
        return new OrderGrouperIterator(rowIter, this.groupCalcs.length, this.aggregators, this.rowMeta);
    }

    private void buildMeta() {
        AbstractDataSet dataSet = this.getInput(0);
        RowMeta innerRowType = dataSet.getRowMeta();
        ExprParser parser = new ExprParser(innerRowType);
        Alias[] aggAliasExprs = parser.transformAlias(parser.resolve(this.info.getAggExprs()));
        this.aggCalcs = new Calc[aggAliasExprs.length];
        for (int i = 0; i < aggAliasExprs.length; ++i) {
            this.aggCalcs[i] = CalcCompiler.compile(innerRowType, aggAliasExprs[i]);
        }
        ArrayList<Field> groupList = new ArrayList<Field>();
        ArrayList<Field> targetFields = new ArrayList<Field>();
        if (this.groupFields != null && this.groupFields.length > 0) {
            Alias[] groupExprs = new Alias[this.groupFields.length];
            this.groupCalcs = new Calc[this.groupFields.length];
            for (int i = 0; i < this.groupFields.length; ++i) {
                Expr expr = parser.parse(this.groupFields[i]);
                this.groupCalcs[i] = CalcCompiler.compile(innerRowType, expr);
                groupExprs[i] = parser.transformAlias(expr);
                Field targetField = new Field(groupExprs[i].getAlias(), expr.getDataType());
                groupList.add(targetField);
                targetFields.add(targetField);
            }
        }
        this.aggregators = new Aggregator[aggAliasExprs.length];
        for (int i = 0; i < aggAliasExprs.length; ++i) {
            IAgg aggExpr = (IAgg)((Object)aggAliasExprs[i].getChild());
            this.aggregators[i] = AggregatorUtils.getAggregator(aggExpr);
            String alias = aggAliasExprs[i].getAlias();
            DataType dataType = aggExpr.getDataType();
            Field targetField = new Field(alias, dataType);
            targetFields.add(targetField);
        }
        this.selectTargetFields();
        this.rowMeta = new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
    }

    private void selectTargetFields() {
        if (this.info.getSelects() != null) {
            // empty if block
        }
    }

    @Override
    public void realClose() {
        if (this.tempStore != null) {
            this.tempStore.close();
        }
        if (this.orderStore != null) {
            this.orderStore.close();
        }
        if (this.input != null) {
            this.input.close();
        }
    }
}

