/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.hashjoin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.JoinHint;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.hashjoin.StarHashJoinDataSet;

public class HashJoinDataSetBuilder
implements HashJoinDataSet {
    private transient AbstractDataSet leftDataSet;
    private ArrayList<HashTable> hashTables = new ArrayList();
    private ArrayList<Boolean> includeNotExists = new ArrayList();
    private ArrayList<String> joinKeyFields = new ArrayList();
    private String[] leftFields;
    private ArrayList<String[]> hashTableFieldss = new ArrayList();
    private ArrayList<JoinHint> hintList = new ArrayList();

    public HashJoinDataSetBuilder(AbstractDataSet leftDataSet, HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields, boolean includeNotExist) {
        this.leftDataSet = leftDataSet;
        this.addHashTable(hashTable, leftJoinKeyField, hashTableSelectFields, includeNotExist);
    }

    @Override
    public HashJoinDataSet addHashTable(HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields) {
        return this.addHashTable(hashTable, leftJoinKeyField, hashTableSelectFields, false);
    }

    @Override
    public HashJoinDataSet addHashTable(HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields, boolean includeNotExist) {
        this.hashTables.add(hashTable);
        this.joinKeyFields.add(leftJoinKeyField);
        this.hashTableFieldss.add(hashTableSelectFields);
        this.includeNotExists.add(includeNotExist);
        return this;
    }

    @Override
    public HashJoinDataSet selectLeftFields(String[] leftFields) {
        this.leftFields = leftFields;
        return this;
    }

    @Override
    public HashJoinDataSet hint(JoinHint hint) {
        this.hintList.add(hint);
        return this;
    }

    @Override
    public DataSet finish() {
        if (this.leftFields == null) {
            throw new AlgoException("Left fields required, please invoke selectLeftFields(String[] leftFields) before finish()");
        }
        StarHashJoinDataSet r = new StarHashJoinDataSet(this.leftDataSet, this);
        this.leftDataSet = null;
        return r;
    }

    public String[] getLeftFields() {
        return this.leftFields;
    }

    public String[] getHashTableFields(int index) {
        return this.hashTableFieldss.get(index);
    }

    public List<JoinHint> getHintList() {
        return this.hintList;
    }

    public HashTable[] getHashTables() {
        return this.hashTables.toArray(new HashTable[this.hashTables.size()]);
    }

    public String[] getJoinKeyFields() {
        return this.joinKeyFields.toArray(new String[this.joinKeyFields.size()]);
    }

    public List<Boolean> getIncludeNotExists() {
        return this.includeNotExists;
    }
}

