/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.join.RowMakeFunc;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.util.AlgoUtil;

public class InnerMergeJoinResult
extends InnerRowIterator {
    private Iterator<Row> outterIter;
    private Iterator<Row> innerIter;
    private Store outterOrderStore;
    private Store innerOrderStore;
    private RowMeta innerRowMeta;
    private int[] innerJoinOnColumns;
    private RowMakeFunc makeFunc;
    private int[] outterJoinOnColumns;
    private RowMeta outterRowMeta;
    private String spanTag;
    private OrderItem[] outterOrderItems;
    private OrderItem[] innerOrderItems;
    private boolean inited;
    private boolean eof;
    private Box box = null;
    private boolean firstMove = true;
    Row outterRow;
    Row innerRow;

    public InnerMergeJoinResult(Iterator<Row> outterIter, RowMeta outterRowMeta, OrderItem[] outterOrderItems, int[] outterJoinOnColumns, Iterator<Row> innerIter, RowMeta innerRowMeta, OrderItem[] innerOrderItems, int[] innerJoinOnColumns, RowMakeFunc makeFunc, String spanTag) {
        this.outterIter = outterIter;
        this.innerIter = innerIter;
        this.outterRowMeta = outterRowMeta;
        this.outterOrderItems = outterOrderItems;
        this.outterJoinOnColumns = outterJoinOnColumns;
        this.innerRowMeta = innerRowMeta;
        this.innerOrderItems = innerOrderItems;
        this.innerJoinOnColumns = innerJoinOnColumns;
        this.makeFunc = makeFunc;
        this.spanTag = spanTag;
        assert (outterJoinOnColumns.length == innerJoinOnColumns.length);
    }

    private void init() {
        this.inited = true;
        boolean bl = this.eof = !this.outterIter.hasNext() || !this.innerIter.hasNext();
        if (this.eof) {
            return;
        }
        this.outterOrderStore = StoreFactory.createOrderStore(this.outterRowMeta, this.outterOrderItems);
        this.outterOrderStore.write(this.outterIter);
        this.outterIter = this.outterOrderStore.getRowIterator();
        this.innerOrderStore = StoreFactory.createOrderStore(this.innerRowMeta, this.innerOrderItems);
        this.innerOrderStore.write(this.innerIter);
        this.innerIter = this.innerOrderStore.getRowIterator();
    }

    @Override
    public boolean _hasNext() {
        if (this.eof) {
            return false;
        }
        if (!this.inited) {
            this.init();
        }
        if (this.box != null) {
            if (this.box.hasNext()) {
                return true;
            }
            this.box.close();
        }
        this.box = null;
        this.move();
        return this.box != null;
    }

    @Override
    public Row _next() {
        return this.box.next();
    }

    private void move() {
        Store innerBoxStore;
        Store outterBoxStore;
        block13: {
            Row innerBeginRow;
            block12: {
                block11: {
                    if (this.firstMove) {
                        if (!this.outterIter.hasNext()) {
                            this.eof = true;
                            return;
                        }
                        this.outterRow = this.outterIter.next();
                        if (!this.innerIter.hasNext()) {
                            this.eof = true;
                            return;
                        }
                        this.innerRow = this.innerIter.next();
                        this.firstMove = false;
                    }
                    if (this.outterRow == null || this.innerRow == null) {
                        return;
                    }
                    while (true) {
                        int c;
                        if ((c = this.compare(this.outterRow, this.innerRow)) < 0) {
                            if (this.outterIter.hasNext()) {
                                this.outterRow = this.outterIter.next();
                                continue;
                            }
                            this.eof = true;
                            return;
                        }
                        if (c <= 0) break block11;
                        if (!this.innerIter.hasNext()) break;
                        this.innerRow = this.innerIter.next();
                    }
                    this.eof = true;
                    return;
                }
                Row outterBeginRow = this.outterRow;
                innerBeginRow = this.innerRow;
                this.outterRow = null;
                this.innerRow = null;
                outterBoxStore = StoreFactory.createSequenceStore(this.outterRowMeta);
                innerBoxStore = StoreFactory.createSequenceStore(this.innerRowMeta);
                outterBoxStore.write(outterBeginRow);
                innerBoxStore.write(innerBeginRow);
                while (this.outterIter.hasNext()) {
                    this.outterRow = this.outterIter.next();
                    if (this.equalsOutter(outterBeginRow, this.outterRow)) {
                        outterBoxStore.write(this.outterRow);
                        continue;
                    }
                    break block12;
                }
                this.outterRow = null;
            }
            while (this.innerIter.hasNext()) {
                this.innerRow = this.innerIter.next();
                if (this.equalsInner(innerBeginRow, this.innerRow)) {
                    innerBoxStore.write(this.innerRow);
                    continue;
                }
                break block13;
            }
            this.innerRow = null;
        }
        this.box = new Box(outterBoxStore, innerBoxStore);
    }

    private boolean equalsInner(Row innerBeginRow, Row row2) {
        for (int i = 0; i < this.innerJoinOnColumns.length; ++i) {
            Object o2;
            int column = this.innerJoinOnColumns[i];
            Object o1 = innerBeginRow.get(column);
            if (AlgoUtil.equal(o1, o2 = row2.get(column))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsOutter(Row outterBeginRow, Row row2) {
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            Object o2;
            int column = this.outterJoinOnColumns[i];
            Object o1 = outterBeginRow.get(column);
            if (AlgoUtil.equal(o1, o2 = row2.get(column))) continue;
            return false;
        }
        return true;
    }

    private int compare(Row outterRow, Row innerRow) {
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            Object o2;
            Object o1 = outterRow.get(this.outterJoinOnColumns[i]);
            int r = AlgoUtil.compareValue(o1, o2 = innerRow.get(this.innerJoinOnColumns[i]));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public void close() {
        if (this.box != null) {
            this.box.close();
        }
        if (this.outterOrderStore != null) {
            this.outterOrderStore.close();
        }
        if (this.innerOrderStore != null) {
            this.innerOrderStore.close();
        }
    }

    class Box
    implements Iterator<Row> {
        Iterator<Row> outterIter;
        Iterator<Row> innerIter;
        Row outterRow;
        Row innerRow;
        private Store innerBoxStore;
        private Store outterBoxStore;
        boolean closed;

        public Box(Store outterBoxStore, Store innerBoxStore) {
            this.outterBoxStore = outterBoxStore;
            this.innerBoxStore = innerBoxStore;
            this.outterIter = outterBoxStore.getRowIterator();
            this.innerIter = innerBoxStore.getRowIterator();
        }

        @Override
        public boolean hasNext() {
            return this.outterIter.hasNext() || this.innerIter.hasNext();
        }

        @Override
        public Row next() {
            if (!this.innerIter.hasNext()) {
                this.innerIter = this.innerBoxStore.getRowIterator();
                this.innerRow = this.innerIter.next();
                this.outterRow = this.outterIter.next();
            } else {
                if (this.outterRow == null) {
                    this.outterRow = this.outterIter.next();
                }
                this.innerRow = this.innerIter.next();
            }
            return InnerMergeJoinResult.this.makeFunc.make(this.outterRow, this.innerRow);
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                try {
                    this.outterBoxStore.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.innerBoxStore.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

