/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.JoinDataSet;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.join.JoinPolicy;
import kd.bos.algo.dataset.join.NotInnerMergeJoinResult;
import kd.bos.algo.dataset.join.NotInnerNestJoinResult;
import kd.bos.algo.dataset.join.NotInnerType;
import kd.bos.algo.dataset.store.Store;

public class NotInnerJoinDataSet
extends JoinDataSet {
    private JoinType joinType;
    private JoinHint joinHint;

    public NotInnerJoinDataSet(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinDataSetBuilder builder) {
        super(builder.getJoinType().getName(), leftDataSet, rightDataSet, builder);
        this.joinType = builder.getJoinType();
        this.joinHint = builder.getJoinHint();
    }

    private NotInnerType getNotInnerType(boolean x) {
        if (JoinType.FULL == this.joinType) {
            return NotInnerType.Both;
        }
        if (JoinType.RIGHT == this.joinType && x || JoinType.RIGHT != this.joinType && !x) {
            return NotInnerType.Outter;
        }
        return NotInnerType.Inner;
    }

    @Override
    protected InnerRowIterator createIterator() {
        int rightSize;
        this.checkClosed();
        AbstractDataSet leftDataSet = this.getLeftDataSet();
        AbstractDataSet rightDataSet = this.getRightDataSet();
        if (this.joinHint.isUseMerge()) {
            return new NotInnerMergeJoinResult(leftDataSet.innerIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightDataSet.innerIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
        }
        Store leftStore = leftDataSet.getStore();
        Store rightStore = rightDataSet.getStore();
        if (leftStore != null && rightStore != null) {
            int rightSize2;
            int leftSize = leftStore.size();
            if (leftSize >= (rightSize2 = rightStore.size())) {
                if (this.joinHint.isUseNest() || rightSize2 <= JoinPolicy.getThreshold()) {
                    return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
                }
                return new NotInnerMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
            }
            if (this.joinHint.isUseMerge()) {
                return new NotInnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
            }
            if (this.joinHint.isUseNest() || leftSize <= JoinPolicy.getThreshold()) {
                return new NotInnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
            }
            return new NotInnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
        }
        if (leftStore != null) {
            int leftSize = leftStore.size();
            if (leftSize <= JoinPolicy.getThreshold()) {
                return new NotInnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
            }
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
            int rightSize3 = rightStore.size();
            if (rightSize3 <= JoinPolicy.getThreshold()) {
                return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
            }
            if (this.joinHint.isUseNest()) {
                if (leftSize > rightSize3) {
                    return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
                }
                return new NotInnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
            }
            if (leftSize > rightSize3) {
                return new NotInnerMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
            }
            return new NotInnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
        }
        if (rightStore == null) {
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
        }
        if ((rightSize = rightStore.size()) <= JoinPolicy.getThreshold()) {
            return new NotInnerNestJoinResult(leftDataSet.innerIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
        }
        leftDataSet.ensureStore();
        leftStore = leftDataSet.getStore();
        int leftSize = leftStore.size();
        if (leftSize <= JoinPolicy.getThreshold()) {
            return new NotInnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
        }
        if (this.joinHint.isUseNest()) {
            if (leftSize > rightSize) {
                return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
            }
            return new NotInnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
        }
        if (leftSize > rightSize) {
            return new NotInnerMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
        }
        return new NotInnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
    }
}

