/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.NestInnerIndex;
import kd.bos.algo.dataset.join.NotInnerType;
import kd.bos.algo.dataset.join.RowMakeFunc;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.util.ArrayKey;

public class NotInnerNestJoinResult
extends InnerRowIterator {
    private Iterator<Row> outterIter;
    private Store innerStore;
    private int[] innerJoinOnColumns;
    private RowMakeFunc makeFunc;
    private int[] outterJoinOnColumns;
    private NotInnerType nit;
    private NestInnerIndex innerIndex;
    private boolean inited;
    private final Object[] keys;
    private final int keyLen;
    private boolean empty = false;
    private Iterator<Row> innerIter;
    private Iterator<Row> remainInnerIter;
    private Row outterRow;
    private boolean outterEmpty;
    private boolean innerEmpty;
    private HashSet<Object> usedInnerIndexKeys = new HashSet();

    public NotInnerNestJoinResult(Iterator<Row> outterIter, int[] outterJoinOnColumns, Store innerStore, RowMeta innerRowMeta, int[] innerJoinOnColumns, RowMakeFunc makeFunc, NotInnerType nit) {
        this.outterIter = outterIter;
        this.outterJoinOnColumns = outterJoinOnColumns;
        this.innerStore = innerStore;
        this.innerJoinOnColumns = innerJoinOnColumns;
        this.makeFunc = makeFunc;
        this.nit = nit;
        this.keyLen = outterJoinOnColumns.length;
        this.keys = new Object[this.keyLen];
    }

    private void init() {
        this.inited = true;
        this.outterEmpty = !this.outterIter.hasNext();
        boolean bl = this.innerEmpty = this.innerStore.size() == 0;
        if (this.outterEmpty && this.innerEmpty) {
            this.empty = true;
            return;
        }
        if (!this.outterEmpty && this.innerEmpty) {
            if (NotInnerType.Inner == this.nit) {
                this.empty = true;
                return;
            }
            return;
        }
        if (this.outterEmpty && !this.innerEmpty) {
            if (NotInnerType.Outter == this.nit) {
                this.empty = true;
                return;
            }
            this.buildIndex();
            this.makeRemainInnerIter();
            return;
        }
        this.buildIndex();
    }

    private void buildIndex() {
        this.innerIndex = new NestInnerIndex(this.innerJoinOnColumns);
        this.innerIndex.build(this.innerStore);
    }

    @Override
    public boolean _hasNext() {
        if (!this.inited) {
            this.init();
        }
        if (this.empty) {
            return false;
        }
        if (this.nit == NotInnerType.Outter) {
            if (this.innerEmpty) {
                return this.outterIter.hasNext();
            }
            if (this.innerIter != null && this.innerIter.hasNext()) {
                return true;
            }
            if (!this.outterIter.hasNext()) {
                return false;
            }
            this.innerIter = this.getInnerIter();
            return true;
        }
        if (this.nit == NotInnerType.Inner) {
            if (this.remainInnerIter != null) {
                return this.remainInnerIter.hasNext();
            }
            if (this.innerIter != null && this.innerIter.hasNext()) {
                return true;
            }
            if (this.outterIter.hasNext()) {
                this.innerIter = this.getInnerIterLoop();
                if (this.innerIter != null) {
                    return true;
                }
            }
            if (!this.outterIter.hasNext()) {
                if (this.remainInnerIter == null) {
                    this.makeRemainInnerIter();
                }
                return this.remainInnerIter.hasNext();
            }
        } else if (this.nit == NotInnerType.Both) {
            if (this.innerEmpty) {
                return this.outterIter.hasNext();
            }
            if (this.remainInnerIter != null) {
                return this.remainInnerIter.hasNext();
            }
            if (this.innerIter != null && this.innerIter.hasNext()) {
                return true;
            }
            if (!this.outterIter.hasNext()) {
                if (this.remainInnerIter == null) {
                    this.makeRemainInnerIter();
                }
                return this.remainInnerIter.hasNext();
            }
            this.innerIter = this.getInnerIter();
            return true;
        }
        return false;
    }

    @Override
    public Row _next() {
        if (this.nit == NotInnerType.Outter) {
            if (this.innerEmpty) {
                this.outterRow = this.outterIter.next();
                return this.makeFunc.make(this.outterRow, null);
            }
            if (this.innerIter == null) {
                return this.makeFunc.make(this.outterRow, null);
            }
            Row row = this.innerIter.next();
            return this.makeFunc.make(this.outterRow, row);
        }
        if (this.nit == NotInnerType.Inner) {
            if (this.remainInnerIter != null && this.remainInnerIter.hasNext()) {
                Row row = this.remainInnerIter.next();
                return this.makeFunc.make(null, row);
            }
            Row row = this.innerIter.next();
            return this.makeFunc.make(this.outterRow, row);
        }
        if (this.innerEmpty) {
            this.outterRow = this.outterIter.next();
            return this.makeFunc.make(this.outterRow, null);
        }
        if (this.remainInnerIter != null && this.remainInnerIter.hasNext()) {
            Row row = this.remainInnerIter.next();
            return this.makeFunc.make(null, row);
        }
        if (this.innerIter == null) {
            return this.makeFunc.make(this.outterRow, null);
        }
        Row row = this.innerIter.next();
        return this.makeFunc.make(this.outterRow, row);
    }

    private void makeRemainInnerIter() {
        this.remainInnerIter = new InnerRemainIter();
    }

    private Iterator<Row> getInnerIterLoop() {
        while (this.outterIter.hasNext()) {
            this.outterRow = this.outterIter.next();
            for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
                this.keys[i] = this.outterRow.get(this.outterJoinOnColumns[i]);
            }
            Object key = this.keyLen == 1 ? this.keys[0] : this.keys;
            Iterator<Row> iter = this.innerIndex.get(key);
            if (iter == null) continue;
            if (this.keyLen == 1) {
                this.usedInnerIndexKeys.add(key);
            } else {
                this.usedInnerIndexKeys.add(new ArrayKey(Arrays.copyOf(this.keys, this.keys.length)));
            }
            return iter;
        }
        return null;
    }

    private Iterator<Row> getInnerIter() {
        this.outterRow = this.outterIter.next();
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            this.keys[i] = this.outterRow.get(this.outterJoinOnColumns[i]);
        }
        Object key = this.keyLen == 1 ? this.keys[0] : this.keys;
        Iterator<Row> iter = this.innerIndex.get(key);
        if (iter != null) {
            if (this.keyLen == 1) {
                this.usedInnerIndexKeys.add(key);
            } else {
                this.usedInnerIndexKeys.add(new ArrayKey(Arrays.copyOf(this.keys, this.keys.length)));
            }
            return iter;
        }
        return null;
    }

    class InnerRemainIter
    implements Iterator<Row> {
        Iterator<Object> keyIter;
        Iterator<Row> itemIter;
        Object key;
        private boolean eof = false;

        InnerRemainIter() {
            this.keyIter = NotInnerNestJoinResult.this.innerIndex.keyIter();
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.itemIter != null && this.itemIter.hasNext()) {
                return true;
            }
            this.itemIter = null;
            while (this.keyIter.hasNext()) {
                this.key = this.keyIter.next();
                if (this.key instanceof Object[]) {
                    this.key = new ArrayKey((Object[])this.key);
                }
                if (NotInnerNestJoinResult.this.usedInnerIndexKeys.contains(this.key)) continue;
                this.itemIter = NotInnerNestJoinResult.this.innerIndex.get(this.key);
                break;
            }
            if (this.itemIter == null) {
                this.eof = true;
                return false;
            }
            return true;
        }

        @Override
        public Row next() {
            return this.itemIter.next();
        }
    }
}

