/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join.hhj;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.join.HHJMemory;
import kd.bos.algo.dataset.join.hhj.HhjJoinFunction;
import kd.bos.algo.dataset.join.hhj.MutableHashTable;
import kd.bos.algox.RowX;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.util.MutableObjectIterator;

public class HybridHashJoiner {
    protected final MutableHashTable<RowX, RowX> hashJoin;
    protected final TypeSerializer<RowX> probeSideSerializer;
    private final MutableObjectIterator<RowX> firstInput;
    private final MutableObjectIterator<RowX> secondInput;
    private final boolean buildSideOuterJoin;
    private final boolean probeSideOuterJoin;
    private volatile boolean running = true;
    private HhjJoinFunction joinFunction;

    public HybridHashJoiner(MutableObjectIterator<RowX> firstInput, MutableObjectIterator<RowX> secondInput, TypeSerializer<RowX> serializer1, TypeComparator<RowX> comparator1, TypeSerializer<RowX> serializer2, TypeComparator<RowX> comparator2, TypePairComparator<RowX, RowX> pairComparator, boolean probeSideOuterJoin, boolean buildSideOuterJoin, boolean useBitmapFilters, HhjJoinFunction joinFunction, HHJMemory memory) throws MemoryAllocationException {
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.probeSideSerializer = serializer1;
        this.joinFunction = joinFunction;
        if (useBitmapFilters && probeSideOuterJoin) {
            throw new IllegalArgumentException("Bitmap filter may not be activated for joining with empty build side");
        }
        this.probeSideOuterJoin = probeSideOuterJoin;
        this.buildSideOuterJoin = buildSideOuterJoin;
        this.hashJoin = this.getHashJoin(serializer2, comparator2, serializer1, comparator1, pairComparator, memory.getMemorySegments(), memory.getIoManager(), useBitmapFilters);
    }

    public <BT, PT> MutableHashTable<BT, PT> getHashJoin(TypeSerializer<BT> buildSideSerializer, TypeComparator<BT> buildSideComparator, TypeSerializer<PT> probeSideSerializer, TypeComparator<PT> probeSideComparator, TypePairComparator<PT, BT> pairComparator, List<MemorySegment> memorySegments, IOManager ioManager, boolean useBloomFilters) throws MemoryAllocationException {
        return new MutableHashTable<BT, PT>(buildSideSerializer, probeSideSerializer, buildSideComparator, probeSideComparator, pairComparator, memorySegments, ioManager, useBloomFilters);
    }

    public void open() throws IOException, MemoryAllocationException, InterruptedException {
        this.hashJoin.open(this.secondInput, this.firstInput, this.buildSideOuterJoin);
    }

    public List<MemorySegment> closeAndGetFreedMemory() {
        this.hashJoin.close();
        return this.hashJoin.getFreedMemory();
    }

    public Iterator<Row> getRowIterator() {
        if (this.probeSideOuterJoin && this.buildSideOuterJoin) {
            return new BothSideOuterIterator();
        }
        if (this.buildSideOuterJoin) {
            return new BuildSideOuterIterator();
        }
        if (this.probeSideOuterJoin) {
            return new ProbeSideOuterIterator();
        }
        return new InnerIterator();
    }

    public Row makeRow(RowX probeRowX, RowX buildRowX) {
        return this.joinFunction.join(probeRowX, buildRowX);
    }

    public void abort() {
        this.running = false;
        this.hashJoin.abort();
    }

    public class InnerIterator
    implements Iterator<Row> {
        private MutableObjectIterator<RowX> buildSideIterator = null;
        private RowX probeRecord = null;
        RowX nextBuildSideRecord = null;
        private boolean hasNexted;
        private boolean eof;

        public InnerIterator() {
            this.moveProbe();
        }

        private void moveProbe() {
            try {
                if (!HybridHashJoiner.this.hashJoin.nextRecord()) {
                    this.eof = true;
                    return;
                }
                this.probeRecord = HybridHashJoiner.this.hashJoin.getCurrentProbeRecord();
                this.buildSideIterator = HybridHashJoiner.this.hashJoin.getBuildSideIterator();
            }
            catch (Throwable t) {
                if (t instanceof AlgoException) {
                    throw (AlgoException)t;
                }
                throw new AlgoException(t);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.hasNexted) {
                return true;
            }
            this.eof = !this.doHasNext();
            this.hasNexted = true;
            return !this.eof;
        }

        private boolean doHasNext() {
            try {
                this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                if (this.nextBuildSideRecord == null) {
                    do {
                        this.moveProbe();
                        if (this.eof) {
                            return false;
                        }
                        this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                    } while (this.nextBuildSideRecord == null);
                }
                return true;
            }
            catch (Exception e) {
                throw new AlgoException(e);
            }
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNexted = false;
            return HybridHashJoiner.this.makeRow(this.probeRecord, this.nextBuildSideRecord);
        }
    }

    public class BothSideOuterIterator
    implements Iterator<Row> {
        private MutableObjectIterator<RowX> buildSideIterator = null;
        private RowX probeRecord = null;
        RowX nextBuildSideRecord = null;
        private boolean hasNexted;
        private boolean eof;
        private boolean probeHasData;

        public BothSideOuterIterator() {
            this.moveProbe();
        }

        private void moveProbe() {
            try {
                if (!HybridHashJoiner.this.hashJoin.nextRecord()) {
                    this.eof = true;
                    return;
                }
                this.probeHasData = false;
                this.probeRecord = HybridHashJoiner.this.hashJoin.getCurrentProbeRecord();
                this.buildSideIterator = HybridHashJoiner.this.hashJoin.getBuildSideIterator();
            }
            catch (Throwable t) {
                if (t instanceof AlgoException) {
                    throw (AlgoException)t;
                }
                throw new AlgoException(t);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.hasNexted) {
                return true;
            }
            this.eof = !this.doHasNext();
            this.hasNexted = true;
            return !this.eof;
        }

        private boolean doHasNext() {
            try {
                if (this.buildSideIterator == null) {
                    this.moveProbe();
                    if (this.eof) {
                        return false;
                    }
                }
                this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                if (this.nextBuildSideRecord == null && this.probeHasData) {
                    this.moveProbe();
                    if (this.eof) {
                        return false;
                    }
                    this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                }
                if (this.nextBuildSideRecord == null) {
                    this.buildSideIterator = null;
                } else {
                    this.probeHasData = true;
                }
                return true;
            }
            catch (Exception e) {
                throw new AlgoException(e);
            }
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNexted = false;
            return HybridHashJoiner.this.makeRow(this.probeRecord, this.nextBuildSideRecord);
        }
    }

    public class BuildSideOuterIterator
    implements Iterator<Row> {
        private MutableObjectIterator<RowX> buildSideIterator = null;
        private RowX probeRecord = null;
        RowX nextBuildSideRecord = null;
        private boolean hasNexted;
        private boolean eof;

        public BuildSideOuterIterator() {
            this.moveProbe();
        }

        private void moveProbe() {
            try {
                if (!HybridHashJoiner.this.hashJoin.nextRecord()) {
                    this.eof = true;
                    return;
                }
                this.probeRecord = HybridHashJoiner.this.hashJoin.getCurrentProbeRecord();
                this.buildSideIterator = HybridHashJoiner.this.hashJoin.getBuildSideIterator();
            }
            catch (Throwable t) {
                if (t instanceof AlgoException) {
                    throw (AlgoException)t;
                }
                throw new AlgoException(t);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.hasNexted) {
                return true;
            }
            this.eof = !this.doHasNext();
            this.hasNexted = true;
            return !this.eof;
        }

        private boolean doHasNext() {
            try {
                this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                if (this.nextBuildSideRecord == null) {
                    do {
                        this.moveProbe();
                        if (this.eof) {
                            return false;
                        }
                        this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                    } while (this.nextBuildSideRecord == null);
                }
                return true;
            }
            catch (Exception e) {
                throw new AlgoException(e);
            }
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNexted = false;
            return HybridHashJoiner.this.makeRow(this.probeRecord, this.nextBuildSideRecord);
        }
    }

    public class ProbeSideOuterIterator
    implements Iterator<Row> {
        private MutableObjectIterator<RowX> buildSideIterator = null;
        private RowX probeRecord = null;
        RowX nextBuildSideRecord = null;
        private boolean hasNexted;
        private boolean eof;
        private boolean probeHasData;

        public ProbeSideOuterIterator() {
            this.moveProbe();
        }

        private void moveProbe() {
            try {
                if (!HybridHashJoiner.this.hashJoin.nextRecord()) {
                    this.eof = true;
                    return;
                }
                this.probeHasData = false;
                this.probeRecord = HybridHashJoiner.this.hashJoin.getCurrentProbeRecord();
                this.buildSideIterator = HybridHashJoiner.this.hashJoin.getBuildSideIterator();
            }
            catch (Throwable t) {
                if (t instanceof AlgoException) {
                    throw (AlgoException)t;
                }
                throw new AlgoException(t);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.hasNexted) {
                return true;
            }
            this.eof = !this.doHasNext();
            this.hasNexted = true;
            return !this.eof;
        }

        private boolean doHasNext() {
            try {
                if (this.buildSideIterator == null) {
                    this.moveProbe();
                    if (this.eof) {
                        return false;
                    }
                }
                this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                if (this.nextBuildSideRecord == null && this.probeHasData) {
                    this.moveProbe();
                    if (this.eof) {
                        return false;
                    }
                    this.nextBuildSideRecord = (RowX)this.buildSideIterator.next();
                }
                if (this.nextBuildSideRecord == null) {
                    this.buildSideIterator = null;
                } else {
                    this.probeHasData = true;
                }
                return true;
            }
            catch (Exception e) {
                throw new AlgoException(e);
            }
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNexted = false;
            return HybridHashJoiner.this.makeRow(this.probeRecord, this.nextBuildSideRecord);
        }
    }
}

