/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.order;

import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.StoreFactory;

public class OrderDataSet
extends AbstractDataSet {
    private OrderItem[] orderItems;
    AbstractDataSet input;

    public OrderDataSet(AbstractDataSet child, OrderItem[] orderItems) {
        super("Order", child);
        this.orderItems = orderItems;
        this.rowMeta = child.getRowMeta();
    }

    public OrderDataSet(AbstractDataSet child, String[] exprs) {
        this(child, exprs, null);
    }

    public OrderDataSet(AbstractDataSet child, String[] exprs, boolean[] descs) {
        super("Order", child);
        this.orderItems = OrderDataSet.buildOrderItems(exprs, descs);
        this.rowMeta = child.getRowMeta();
    }

    private static OrderItem[] buildOrderItems(String[] exprs, boolean[] descs) {
        OrderItem[] orderItems = new OrderItem[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            String[] parts = exprs[i].split(" ");
            String sortExpr = parts[0];
            boolean asc = parts.length > 1 ? "asc".equalsIgnoreCase(parts[1]) : (descs == null ? true : !descs[i]);
            orderItems[i] = new OrderItem(sortExpr, asc);
        }
        return orderItems;
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        this.input = this.getInput(0);
        this.store = StoreFactory.createOrderStore(this.rowMeta, this.orderItems);
        this.store.write(this.input.innerIterator());
        this.detachInputs(false);
        return InnerRowIterator.wrapper(this.store.getRowIterator());
    }

    @Override
    public void realClose() {
        if (this.input != null) {
            this.input.close();
        }
    }
}

