/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.MappedSelectRow;

public class SimpleSelectDataSet
extends AbstractDataSet {
    private Map<String, Integer> fieldIndexMapper = new HashMap<String, Integer>(4);
    private int[] fieldIndexIntMapper = null;

    public SimpleSelectDataSet(AbstractDataSet dataSet, String[] fieldRefs, Field[] targetFields) {
        super("SimpleSelect", dataSet);
        this.checkDuplicateName(targetFields);
        this.rowMeta = new RowMeta(targetFields);
        RowMeta rm = dataSet.getRowMeta();
        this.fieldIndexIntMapper = new int[fieldRefs.length];
        for (int i = 0; i < fieldRefs.length; ++i) {
            int index;
            Field field = targetFields[i];
            String alias = field.getAlias();
            this.fieldIndexIntMapper[i] = index = rm.getFieldIndex(fieldRefs[i]);
            this.fieldIndexMapper.put(alias, index);
        }
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    private void checkDuplicateName(Field[] targetFields) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < targetFields.length; ++i) {
            if (set.add(targetFields[i].getAlias())) continue;
            throw new AlgoException("Duplicated field alias: " + targetFields[i].getAlias());
        }
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet dataSet = this.getInput(0);
        final InnerRowIterator iter = dataSet.innerIterator();
        final MappedSelectRow cursor = new MappedSelectRow(this.getRowMeta(), this.fieldIndexMapper, this.fieldIndexIntMapper);
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row _next() {
                Row row = (Row)iter.next();
                cursor.setRow(row);
                return cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void realClose() {
    }
}

