/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heap;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.ListStore;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.heap.HeapLimitPolicy;
import kd.bos.algo.dataset.store.heap.HeapStore;
import kd.bos.algo.dataset.store.sort.RowOrderComparator;

public class HeapOrderStore
extends HeapStore {
    private ArrayList<Row> list = new ArrayList();
    private int[] orderIndexes;
    private boolean[] descs;
    private boolean sorted;

    public HeapOrderStore(HeapLimitPolicy limitPolicy, int[] orderIndexes, boolean[] descs) {
        super(limitPolicy);
        this.orderIndexes = orderIndexes;
        this.descs = descs;
    }

    @Override
    public void addRow(Row row) {
        this.list.add(((AbstractRow)row).persist());
    }

    @Override
    public Iterator<Row> getResultIterator() {
        if (!this.sorted) {
            this.doSort();
            this.sorted = true;
        }
        return this.list.iterator();
    }

    private void doSort() {
        this.list.sort(new RowOrderComparator(this.orderIndexes, this.descs));
    }

    @Override
    public Iterator<Row> getOriginalIterator() {
        return this.list.iterator();
    }

    @Override
    public void close() {
        if (this.list != null) {
            super.close();
            this.list = null;
        }
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Store toStore(RowMeta rowMeta) {
        if (!this.sorted) {
            this.doSort();
        }
        return new ListStore(rowMeta, this.list);
    }
}

