/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heap;

import kd.bos.algo.dataset.store.heap.GlobalMaxRowsLimitPolicy;
import kd.bos.algo.dataset.store.heap.HeapLimitPolicy;
import kd.bos.algo.dataset.store.heap.HeapOrderStore;
import kd.bos.algo.dataset.store.heap.HeapSequenceStore;
import kd.bos.algo.dataset.store.heap.HeapStore;

public class HeapStoreFactory {
    private static int default_globalHeapMaxRowsLimit = 1000000;
    private static String KEY_HEAPCACHE_GLOBALMAXROWS = "algo.heapcache.globalMaxRows";
    private static Object createGlobalLock = new Object();
    private static GlobalMaxRowsLimitPolicy globalPolicy = null;

    private static HeapLimitPolicy getPolicy() {
        return HeapStoreFactory.getGlobalPolicy();
    }

    private static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GlobalMaxRowsLimitPolicy createGlobalPolicy() {
        Object object = createGlobalLock;
        synchronized (object) {
            if (globalPolicy != null) {
                return globalPolicy;
            }
            String str = System.getProperty(KEY_HEAPCACHE_GLOBALMAXROWS);
            if (str == null) {
                return new GlobalMaxRowsLimitPolicy(default_globalHeapMaxRowsLimit);
            }
            int heapMaxRowsLimit = HeapStoreFactory.parseInt(str);
            if (heapMaxRowsLimit < 0) {
                return new GlobalMaxRowsLimitPolicy(default_globalHeapMaxRowsLimit);
            }
            return new GlobalMaxRowsLimitPolicy(heapMaxRowsLimit);
        }
    }

    private static HeapLimitPolicy getGlobalPolicy() {
        if (globalPolicy == null) {
            globalPolicy = HeapStoreFactory.createGlobalPolicy();
        } else {
            int heapMaxRowsLimit;
            String str = System.getProperty(KEY_HEAPCACHE_GLOBALMAXROWS);
            if (str != null && (heapMaxRowsLimit = HeapStoreFactory.parseInt(str)) > 0) {
                globalPolicy.setMaxRowsLimit(heapMaxRowsLimit);
            }
        }
        return globalPolicy;
    }

    public static HeapStore createHeapSequenceStore() {
        HeapLimitPolicy policy = HeapStoreFactory.getPolicy();
        return new HeapSequenceStore(policy);
    }

    public static HeapStore createHeapOrderStore(int[] orderIndexes, boolean[] descs) {
        HeapLimitPolicy policy = HeapStoreFactory.getPolicy();
        return new HeapOrderStore(policy, orderIndexes, descs);
    }
}

