/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.sort.PartialOrderPriorityQueue;

public class MergeIterator
implements Iterator<Row> {
    private final PartialOrderPriorityQueue<HeadStream> heap;
    private final Comparator<Row> comparator;

    public MergeIterator(List<Iterator<Row>> iterators, Comparator<Row> comparator) throws IOException {
        this.comparator = comparator;
        this.heap = new PartialOrderPriorityQueue<HeadStream>(new HeadStreamComparator(), iterators.size());
        for (Iterator<Row> iterator : iterators) {
            this.heap.add(new HeadStream(iterator));
        }
    }

    @Override
    public boolean hasNext() {
        return this.heap.size() > 0;
    }

    @Override
    public Row next() {
        if (this.heap.size() > 0) {
            HeadStream top = this.heap.peek();
            Row result = top.getHead();
            if (!top.nextHead()) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
            return result;
        }
        return null;
    }

    private final class HeadStreamComparator
    implements Comparator<HeadStream> {
        private HeadStreamComparator() {
        }

        @Override
        public int compare(HeadStream o1, HeadStream o2) {
            return MergeIterator.this.comparator.compare(o1.head, o2.head);
        }
    }

    private static final class HeadStream {
        private final Iterator<Row> iterator;
        private Row head;

        public HeadStream(Iterator<Row> iterator) throws IOException {
            this.iterator = iterator;
            if (!this.nextHead()) {
                throw new IllegalStateException();
            }
        }

        public Row getHead() {
            return this.head;
        }

        public boolean nextHead() {
            try {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.head = this.iterator.next();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

