/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.thread.ThreadLifeCycleManager;

public class SortThreadPools {
    private static int coreThreads = 12;
    private static int maxThreads = 64;
    private static String poolName;
    private static final AtomicInteger atomicInteger;
    private static ExecutorService pools;

    public static void execute(Runnable r) {
        r = ThreadLifeCycleManager.wrapRunnable((Runnable)r);
        pools.execute(r);
    }

    static {
        String s = System.getProperty("algo.sort.thread.coreThreads");
        if (s != null) {
            coreThreads = Integer.parseInt(s);
        }
        if ((s = System.getProperty("algo.sort.thread.maxThreads")) != null) {
            maxThreads = Integer.parseInt(s);
        }
        poolName = "Algo-Sort-Pool";
        atomicInteger = new AtomicInteger(0);
        pools = new ThreadPoolExecutor(coreThreads, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-" + atomicInteger.incrementAndGet());
            }
        });
    }
}

