/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;

public class LazyMemorySegmentSource
implements MemorySegmentSource {
    private MemoryManager mm;
    private int maxNum;
    private int allocatedNum;
    private Object owner;
    private ArrayList<MemorySegment> allocatedMemorySegments = new ArrayList(8);
    private ArrayList<MemorySegment> tempAllocating = new ArrayList(1);

    public LazyMemorySegmentSource(Object owner, MemoryManager mm, int maxNum) {
        this.owner = owner;
        this.mm = mm;
        this.maxNum = maxNum;
    }

    public List<MemorySegment> getAllSegment() {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>();
        try {
            this.mm.allocatePages(this.owner, list, this.maxNum);
            this.allocatedNum = this.maxNum;
            return list;
        }
        catch (MemoryAllocationException e) {
            throw new AlgoException(e);
        }
    }

    public MemorySegment nextSegment() {
        if (this.allocatedNum < this.maxNum) {
            ++this.allocatedNum;
            try {
                this.mm.allocatePages(this.owner, this.tempAllocating, 1);
                MemorySegment ret = this.tempAllocating.remove(0);
                this.allocatedMemorySegments.add(ret);
                return ret;
            }
            catch (MemoryAllocationException e) {
                throw new AlgoException(e);
            }
        }
        return null;
    }

    public void close() {
        this.mm.release(this.allocatedMemorySegments);
    }
}

