/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.UnknownType;

public class NumericType
extends DataType {
    public static NumericType instance = new NumericType(200, "Numeric");
    private static final long serialVersionUID = -1352757987136279685L;

    protected NumericType(int ordinal, String name) {
        super(ordinal, name);
    }

    @Override
    public int getFixedSize() {
        return 0;
    }

    @Override
    public boolean acceptsType(DataType other) {
        if (other instanceof NullType || other instanceof AnyType || other instanceof UnknownType) {
            return true;
        }
        return other instanceof NumericType;
    }

    public static NumericType computeCompatibleUp(NumericType left, NumericType right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return left.getCompatibleLevel() >= right.getCompatibleLevel() ? right : left;
    }

    public static NumericType computeCompatibleDown(NumericType left, NumericType right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return left.getCompatibleLevel() >= right.getCompatibleLevel() ? left : right;
    }

    @Override
    public Class<?> getJavaType() {
        return Number.class;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    int getCompatibleLevel() {
        return 0;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSqlType() {
        return 2;
    }
}

