/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.NullType;

public class StringType
extends DataType {
    private static final long serialVersionUID = -7906379051663118840L;

    public StringType() {
        super(1, "String");
    }

    @Override
    public int getFixedSize() {
        return 0;
    }

    @Override
    public boolean acceptsType(DataType other) {
        if (other instanceof NullType || other instanceof AnyType) {
            return true;
        }
        return other instanceof StringType;
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    @Override
    public int guessHeapSize(Object value) {
        if (value == null) {
            return 4;
        }
        String str = (String)value;
        int div = str.length() * 2 / 8;
        int mod = str.length() * 2 % 8;
        if (mod > 0) {
            ++div;
        }
        return 24 + div * 8;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        output.writeUTF((String)value);
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        return input.readUTF();
    }

    @Override
    public int getSqlType() {
        return 12;
    }
}

