/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.env.jvm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.AlgoConfig;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.HashTable;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.StreamSourceDataSet;
import kd.bos.algo.dataset.builder.StoreDataSetBuilder;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.dataset.hashjoin.HashTableFactory;
import kd.bos.algo.dataset.input.InputDataSet;
import kd.bos.algo.dataset.join.HHJMemCache;
import kd.bos.algo.dataset.join.hhj.HybridHashJoiner;
import kd.bos.algo.env.Environment;
import kd.bos.algo.streamsource.CollectionStreamSource;
import kd.bos.algo.streamsource.IteratorStreamSource;
import kd.bos.algo.streamsource.ResultSetStreamSource;
import kd.bos.algo.streamsource.StreamSource;
import kd.bos.algo.util.resource.ResourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmEnvironment
extends Environment {
    private static Logger logger = LoggerFactory.getLogger(JvmEnvironment.class);
    private HashSet<AbstractDataSet> dataSets = new HashSet();
    private HashSet<HashTable> hashtables = new HashSet();
    private Set<HybridHashJoiner> hhjs = Collections.synchronizedSet(new HashSet());
    private HHJMemCache hhjMemCache = new HHJMemCache();

    public JvmEnvironment(AlgoConfig config) {
        super(config);
    }

    @Override
    public DataSet createDataSet(Collection<Object[]> rowList, RowMeta rowMeta) {
        return this.createDataSet(new CollectionStreamSource(rowList, rowMeta));
    }

    @Override
    public DataSet createDataSet(Iterable<Object[]> iterable, RowMeta rowMeta) {
        return this.createDataSet(iterable.iterator(), rowMeta);
    }

    @Override
    public DataSet createDataSet(Iterator<Object[]> iterator, RowMeta rowMeta) {
        return this.createDataSet(new IteratorStreamSource(iterator, rowMeta));
    }

    @Override
    public DataSet createDataSet(ResultSet rs) {
        return this.createDataSet(new ResultSetStreamSource(rs));
    }

    @Override
    public DataSet createDataSet(ResultSet rs, RowMeta rowMeta) {
        return this.createDataSet(new ResultSetStreamSource(rs, rowMeta));
    }

    public DataSet createDataSet(StreamSource streamSource) {
        StreamSourceDataSet dataSet = new StreamSourceDataSet(this, streamSource);
        return dataSet;
    }

    @Override
    public DataSet createDataSet(Input ... inputs) {
        InputDataSet dataSet = new InputDataSet(this, inputs);
        return dataSet;
    }

    @Override
    public DataSetBuilder createDataSetBuilder(RowMeta rowMeta) {
        return new StoreDataSetBuilder(this, rowMeta);
    }

    @Override
    public void execute() {
    }

    @Override
    public HashTable toHashTable(AbstractDataSet dataSet, String keyField) {
        RowMeta rowMeta = dataSet.getRowMeta();
        int index = rowMeta.getFieldIndex(keyField);
        return HashTableFactory.createHashTable(dataSet, index);
    }

    @Override
    public void close() {
        this.autoRelease();
    }

    private void autoRelease() {
        for (HashTable h : this.hashtables) {
            h.close();
        }
        ArrayList<AbstractDataSet> toCloseDataSets = new ArrayList<AbstractDataSet>();
        toCloseDataSets.addAll(this.dataSets);
        for (AbstractDataSet dataSet : toCloseDataSets) {
            if (dataSet.getOutputCount() != 0) continue;
            dataSet.close();
        }
        for (HashTable h : this.hashtables) {
            if (!(h instanceof ResourceHolder)) continue;
            ((ResourceHolder)((Object)h)).closeAllResources(false);
        }
        for (AbstractDataSet dataSet : toCloseDataSets) {
            dataSet.closeAllResources(false);
        }
        for (HashTable h : this.hashtables) {
            if (!(h instanceof ResourceHolder)) continue;
            ((ResourceHolder)((Object)h)).closeAllSubResources(false);
        }
        for (AbstractDataSet dataSet : toCloseDataSets) {
            dataSet.closeAllSubResources(false);
        }
        this.fireClosed();
        this.checkAllClosed(toCloseDataSets);
    }

    private void checkAllClosed(ArrayList<AbstractDataSet> toCloseDataSets) {
        for (AbstractDataSet dataset : toCloseDataSets) {
            if (dataset.isClosed()) continue;
            logger.error(String.format("dataset[algoKey=%s, name=%s, id=%s] not closed.", dataset.getEnvironment().getConfig().getKey(), dataset.getName(), dataset.getId()));
            dataset.forceClose();
        }
    }

    @Override
    public void registerDataSet(DataSet dataSet) {
        this.dataSets.add((AbstractDataSet)dataSet);
    }

    @Override
    public void unregisterDataSet(DataSet dataSet) {
        this.dataSets.remove((AbstractDataSet)dataSet);
    }

    @Override
    public CachedDataSet.Builder createCachedDataSetBuilder(RowMeta rowMeta, CacheHint hint) {
        return new CachedDataSetBuilder(rowMeta, hint, null);
    }

    @Override
    public void registerHybridHashJoiner(HybridHashJoiner hhj) {
        this.hhjs.add(hhj);
    }

    @Override
    public void unregisterHybridHashJoiner(HybridHashJoiner hhj) {
        this.hhjs.remove(hhj);
    }

    @Override
    public int getHhjCount() {
        return this.hhjs.size();
    }

    @Override
    public HHJMemCache getHHJMemCache() {
        return this.hhjMemCache;
    }
}

