/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.metrics;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;

public class MetricIterator
implements Iterator<Row>,
DataSet.Listener {
    private Iterator<Row> inner;
    private String name;
    private static String iteratorTimeName = "kd.metrics.algo.dataset.iterator.timer";
    private static Timer timer = MetricSystem.timer((String)iteratorTimeName);
    private static ConcurrentHashMap<String, Timer> timersByName = new ConcurrentHashMap();
    private Timer timerByName = null;
    private Timer.Context context = null;
    private Timer.Context contextByName = null;
    private boolean stoped = false;

    public MetricIterator(String name, Iterator<Row> inner) {
        this.name = name;
        this.inner = inner;
        this.timerByName = this.getTimerByName(name);
    }

    private Timer getTimerByName(String name) {
        Timer timer = timersByName.get(name);
        if (timer != null) {
            return timer;
        }
        timer = MetricSystem.timer((String)(iteratorTimeName + "." + name));
        timersByName.putIfAbsent(name, timer);
        return timer;
    }

    @Override
    public boolean hasNext() {
        boolean b = this.inner.hasNext();
        if (!b && this.context != null) {
            this.context.stop();
            this.contextByName.stop();
            this.stoped = true;
        }
        return b;
    }

    @Override
    public Row next() {
        if (this.context == null) {
            this.context = timer.time();
            this.contextByName = this.timerByName.time();
        }
        return this.inner.next();
    }

    @Override
    public void afterClosed() {
        if (this.context != null && !this.stoped) {
            this.context.stop();
            this.contextByName.stop();
            this.stoped = true;
        }
    }
}

