/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.interpret;

import java.util.Date;
import kd.bos.algo.AlgoException;

public final class ExplicitCheck {
    public static Object checkNotNull(Object value, String errorMessage) {
        if (value == null) {
            throw new AlgoException(errorMessage);
        }
        return value;
    }

    public static String checkString(Object value, String errorMessage) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new AlgoException(String.format(errorMessage, value.toString()));
    }

    public static Number checkNumber(Object value, String errorMessage) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new AlgoException(String.format(errorMessage, value.toString()));
        }
        return (Number)value;
    }

    public static Date checkDate(Object value, String errorMessage) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Date)) {
            throw new AlgoException(String.format(errorMessage, value.toString()));
        }
        return (Date)value;
    }

    public static Boolean checkBoolean(Object value, String errorMessage) {
        return ExplicitCheck.checkType(value, Boolean.class, errorMessage);
    }

    public static <T> T checkType(Object value, Class<T> clazz, String errorMessage) {
        if (value == null) {
            return null;
        }
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        throw new AlgoException(String.format(errorMessage, value.toString()));
    }
}

