/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.resolve;

import kd.bos.algo.AlgoException;
import kd.bos.algo.sql.resolve.Resolver;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.agg.AggExpr;
import kd.bos.algo.sql.tree.agg.AggWithIfExpr;
import kd.bos.algo.sql.tree.agg.AggWithPropertyExpr;
import kd.bos.algo.sql.tree.bind.ColumnRef;
import kd.bos.algo.sql.tree.func.FormulaExpr;

public class ColumnAliasTransformer
implements Resolver {
    public static ColumnAliasTransformer instance = new ColumnAliasTransformer();
    private String execeptionMessage = "Alias espected for:%s";

    @Override
    public Expr resolve(Expr expr) {
        if (expr instanceof Alias) {
            return expr;
        }
        if (expr instanceof ColumnRef) {
            return this.resolveColumnRef((ColumnRef)expr);
        }
        if (expr instanceof AggExpr) {
            return this.resolveAggExpr((AggExpr)expr);
        }
        if (expr instanceof AggWithPropertyExpr) {
            return this.resolveAggWithPropertyExpr((AggWithPropertyExpr)expr);
        }
        if (expr instanceof AggWithIfExpr) {
            return this.resolveAggWithIfExpr((AggWithIfExpr)expr);
        }
        if (expr instanceof FormulaExpr) {
            return new Alias(expr.getLocation(), expr, ((FormulaExpr)expr).getName());
        }
        throw AlgoException.create(this.execeptionMessage, expr.sql());
    }

    public Expr resolveColumnRef(ColumnRef exp) {
        return new Alias(exp.getLocation(), (Expr)exp, exp.getAlias());
    }

    public Expr resolveAggExpr(AggExpr exp) {
        Expr child = exp.getChild();
        if (child instanceof ColumnRef) {
            return new Alias(exp.getLocation(), (Expr)exp, ((ColumnRef)child).getAlias());
        }
        throw AlgoException.create(this.execeptionMessage, exp.sql());
    }

    public Expr resolveAggWithPropertyExpr(AggWithPropertyExpr exp) {
        Expr child = exp.getChild(1);
        if (child instanceof ColumnRef) {
            return new Alias(exp.getLocation(), (Expr)exp, ((ColumnRef)child).getAlias());
        }
        throw AlgoException.create(this.execeptionMessage, exp.sql());
    }

    public Expr resolveAggWithIfExpr(AggWithIfExpr exp) {
        Expr child = exp.getChild(0);
        if (child instanceof ColumnRef) {
            return new Alias(exp.getLocation(), (Expr)exp, ((ColumnRef)child).getAlias());
        }
        throw AlgoException.create(this.execeptionMessage, exp.sql());
    }
}

