/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.resolve;

import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.sql.resolve.TraverResolver;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Unresolved;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedFuncall;

public class SchemaTraverResolver
extends TraverResolver {
    private Schema schema;
    private Schema schema2;
    private Map<String, Object> params;

    public SchemaTraverResolver(Schema schema) {
        this.schema = schema;
    }

    public SchemaTraverResolver(Schema schema, Schema schema2, boolean joinCheckAmbiguous) {
        this.schema = schema;
        this.schema2 = schema2;
    }

    public SchemaTraverResolver(Schema schema, Map<String, Object> params) {
        this.schema = schema;
        this.params = params;
    }

    @Override
    public Expr resolveSelf(Expr expr) {
        if (expr instanceof UnresolvedAttribute) {
            if (this.schema2 != null) {
                Schema schema;
                List<String> nameParts = ((UnresolvedAttribute)expr).getNameParts();
                if (nameParts.size() > 1 && (schema = this.getMatchSchema(nameParts.get(0))) != null) {
                    return ((UnresolvedAttribute)expr).resolve(schema, this.params);
                }
                return ((UnresolvedAttribute)expr).resolve(this.schema, this.schema2, false);
            }
            return ((UnresolvedAttribute)expr).resolve(this.schema, this.params);
        }
        if (expr instanceof Unresolved) {
            return ((Unresolved)((Object)expr)).resolve(this.schema);
        }
        return expr;
    }

    private Schema getMatchSchema(String name) {
        if (this.schema.getTable(name) != null) {
            return this.schema;
        }
        if (this.schema2.getTable(name) != null) {
            return this.schema2;
        }
        return null;
    }

    @Override
    public Expr resolve(Expr expr) {
        if (expr instanceof UnresolvedFuncall && "PreRowValue".equalsIgnoreCase(((UnresolvedFuncall)expr).getName())) {
            return this.resolvePreRowValue(expr);
        }
        return super.resolve(expr);
    }

    private Expr resolvePreRowValue(Expr expr) {
        try {
            return super.resolve(expr);
        }
        catch (AlgoException algoException) {
            return this.resolveSelf(expr);
        }
    }
}

