/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.Relation;

public class AliasedRelation
extends Relation {
    private Relation relation;
    private final String alias;
    private final List<String> columnNames;

    public AliasedRelation(Relation relation, String alias, List<String> columnNames) {
        this(Optional.empty(), relation, alias, columnNames);
    }

    public AliasedRelation(NodeLocation location, Relation relation, String alias, List<String> columnNames) {
        this(Optional.of(location), relation, alias, columnNames);
    }

    public AliasedRelation(Optional<NodeLocation> location, Relation relation, String alias, List<String> columnNames) {
        super(location);
        Objects.requireNonNull(relation, "relation is null");
        Objects.requireNonNull(alias, " is null");
        this.relation = relation;
        this.alias = alias;
        this.columnNames = columnNames;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    public List<Relation> getChildren() {
        return ImmutableList.of((Object)this.relation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("alias", (Object)this.alias).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)o;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.alias, that.alias) && Objects.equals(this.columnNames, that.columnNames);
    }

    public int hashCode() {
        return Objects.hash(this.relation, this.alias, this.columnNames);
    }

    @Override
    public void replaceChild(int index, Node relation) {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (String)"Illegal index %d", (int)index);
        this.relation = (Relation)relation;
    }
}

