/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.FuncFactory;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.tree.Abs;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Concat;
import kd.bos.algo.sql.tree.Contains;
import kd.bos.algo.sql.tree.EndsWith;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Lower;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.StartsWith;
import kd.bos.algo.sql.tree.Unresolved;
import kd.bos.algo.sql.tree.Upper;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.NotSupportCalc;
import kd.bos.algo.sql.tree.func.FuncDef;

public class UnresolvedFuncall
extends Expr
implements Unresolved {
    private String name;
    private boolean distinct;

    public UnresolvedFuncall(Optional<NodeLocation> location, String name, boolean distinct, Expr[] exprs) {
        super(location, exprs, UnresolvedFuncall.repeatDataTypes(DataType.UnknownType, exprs == null ? 0 : exprs.length));
        this.name = name;
        this.distinct = distinct;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public String sql() {
        return this.name + "(" + (this.distinct ? "distinct " : "") + this.joinChildrenSql(this.children) + ")";
    }

    @Override
    public DataType getDataType() {
        return DataType.UnknownType;
    }

    @Override
    public Expr resolve(Schema schema) {
        FuncDef funcDef;
        Expr result = null;
        FuncFactory factory = schema.getFuncFactory();
        if (factory != null && (funcDef = factory.lookupFunc(this.name, this.children)) != null) {
            result = funcDef.createExpr(this.children);
        }
        if ("Concat".equalsIgnoreCase(this.name)) {
            return new Concat(Optional.empty(), this.children);
        }
        if ("Constains".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"Contains() needs two argments.");
            return new Contains(Optional.empty(), this.children[0], this.children[1]);
        }
        if ("StartsWith".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"StartsWith() needs two argments.");
            return new StartsWith(Optional.empty(), this.children[0], this.children[1]);
        }
        if ("EndsWith".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"EndsWith() needs two argments.");
            return new EndsWith(Optional.empty(), this.children[0], this.children[1]);
        }
        if ("Lower".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"Lower() needs one argments.");
            return new Lower(Optional.empty(), this.children[0]);
        }
        if ("Upper".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"Upper() needs one argments.");
            return new Upper(Optional.empty(), this.children[0]);
        }
        if ("Abs".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"Abs() needs one argments.");
            return new Abs(Optional.empty(), this.children[0]);
        }
        if (result == null) {
            throw AlgoException.create("Function %s not found.", this.name);
        }
        return result;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnresolvedFuncall(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        return new NotSupportCalc(this.getClass().getName());
    }
}

