/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.agg;

import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.NumericType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.agg.AggWithPropertyExpr;

public class MaxPExpr
extends AggWithPropertyExpr {
    public MaxPExpr(Optional<NodeLocation> location, Expr expr, Expr propertyExpr) {
        super(location, expr, propertyExpr, "MAXP", (DataType)NumericType.instance);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMaxPExpr(this, context);
    }

    @Override
    public void checkInputTypes() {
        Expr child = super.getChild(0);
        if (child == null) {
            throw AlgoException.create(this.sql() + " argument can't be null, but null found.", new Object[0]);
        }
        DataType dataType = child.getDataType();
        if (!DataType.DateType.acceptsType(dataType) && !NumericType.instance.acceptsType(dataType)) {
            throw AlgoException.create(this.sql() + " DataType not compatible, %s should be %s, but %s found.", child.sql(), "Numeric or Date/Timestamp", dataType);
        }
    }
}

