/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.bind;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.bind.BindRef;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.LeftColumnCalc;
import kd.bos.algo.sql.tree.calc.RightColumnCalc;

public class ColumnRef
extends BindRef<Column> {
    private String alias;
    private boolean right;
    private int index;

    public ColumnRef(Optional<NodeLocation> location, Column ref, String alias) {
        super(location, ref);
        this.alias = alias == null ? ref.getFullName() : alias;
        this.right = "right".equals(ref.getTable().getName());
        this.index = ref.getIndex();
    }

    @Override
    public DataType getDataType() {
        return ((Column)this.ref).getDataType();
    }

    @Override
    public String sql() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return ((Column)this.ref).getName();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnRef(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        if (this.right) {
            return new RightColumnCalc(this.index);
        }
        return new LeftColumnCalc(this.index);
    }
}

