/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import kd.bos.algo.AlgoException;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.calc.Calc;

public final class CaseWhenSimpleWithElseCalc
implements Calc {
    private Calc[] conditionCalcs;
    private Calc[] resultCalcs;
    private Calc elseCalc;
    private int length;
    private Calc valueCalc;

    public CaseWhenSimpleWithElseCalc(Calc valueCalc, Calc[] conditionCalcs, Calc[] resultCalcs, Calc elseCalc) {
        this.valueCalc = valueCalc;
        this.conditionCalcs = conditionCalcs;
        this.resultCalcs = resultCalcs;
        this.elseCalc = elseCalc;
        this.length = conditionCalcs.length;
    }

    private boolean equals(Object value, Object condition) {
        if (value == null) {
            return condition == null;
        }
        if (condition == null) {
            return false;
        }
        if (value instanceof Comparable) {
            try {
                return ((Comparable)value).compareTo((Comparable)condition) == 0;
            }
            catch (Throwable t) {
                throw AlgoException.create("Can't compare %s with %s", t, value.toString(), condition.toString());
            }
        }
        throw AlgoException.create("Can't compare %s with %s, not comparable", value.toString(), condition.toString());
    }

    @Override
    public Object execute(RowFeature row1, RowFeature row2) {
        Object value = this.valueCalc.execute(row1, row2);
        for (int i = 0; i < this.length; ++i) {
            Object c = this.conditionCalcs[i].execute(row1, row2);
            if (!this.equals(value, c)) continue;
            return this.resultCalcs[i].execute(row1, row2);
        }
        return this.elseCalc.execute(row1, row2);
    }
}

