/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class MultiplyCalc
implements Calc {
    private Calc calc1;
    private Calc calc2;

    public MultiplyCalc(Calc calc1, Calc calc2) {
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object execute(RowFeature row1, RowFeature row2) {
        Number left = ExplicitCheck.checkNumber(this.calc1.execute(row1, row2), "* operator apply to number, but %s found.");
        if (left == null) {
            return null;
        }
        Number right = ExplicitCheck.checkNumber(this.calc2.execute(row1, row2), "* operator apply to number, but %s found.");
        if (right == null) {
            return null;
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return AlgoUtil.toBigDecimal(left).multiply(AlgoUtil.toBigDecimal(right));
        }
        if (left instanceof Double || right instanceof Double) {
            return new Double(left.doubleValue() * right.doubleValue());
        }
        if (left instanceof Float || right instanceof Float) {
            return new Float(left.floatValue() * right.floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() * right.longValue());
        }
        return new Integer(left.intValue() * right.intValue());
    }
}

