/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.AlgoException;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class SubstractCalc
implements Calc {
    private Calc calc1;
    private Calc calc2;

    public SubstractCalc(Calc calc1, Calc calc2) {
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object execute(RowFeature row1, RowFeature row2) {
        Object left = this.calc1.execute(row1, row2);
        if (left == null) {
            return null;
        }
        Object right = this.calc2.execute(row1, row2);
        if (right == null) {
            return null;
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return AlgoUtil.toBigDecimal(left).subtract(AlgoUtil.toBigDecimal(right));
        }
        if (left instanceof Long || right instanceof Long) {
            return ((Number)left).longValue() - ((Number)right).longValue();
        }
        if (left instanceof Integer || right instanceof Integer) {
            return ((Number)left).intValue() - ((Number)right).intValue();
        }
        if (left instanceof Double || right instanceof Double) {
            return ((Number)left).doubleValue() - ((Number)right).doubleValue();
        }
        return new AlgoException("Substract only support Number.");
    }
}

