/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.star;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.Table;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.bind.ColumnRef;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.NotSupportCalc;
import kd.bos.algo.sql.tree.star.AllColumn;

public class RelationAllColumn
extends Expr
implements AllColumn {
    public RelationAllColumn(Optional<NodeLocation> location, Table relation) {
        super(location, RelationAllColumn.extractExprs(relation), RelationAllColumn.extractTypes(relation));
    }

    private static Expr[] extractExprs(Table relation) {
        Column[] columns = relation.getColumns();
        Expr[] result = new Expr[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = new ColumnRef(Optional.empty(), columns[i], null);
        }
        return result;
    }

    private static DataType[] extractTypes(Table relation) {
        Column[] columns = relation.getColumns();
        DataType[] result = new DataType[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = columns[i].getDataType();
        }
        return result;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRelationAllColumn(this, context);
    }

    @Override
    public DataType getDataType() {
        return null;
    }

    @Override
    public String sql() {
        return null;
    }

    @Override
    public ColumnRef[] getAll() {
        return (ColumnRef[])this.children;
    }

    @Override
    public Calc compile(CompileContext context) {
        return new NotSupportCalc(this.getClass().getName());
    }
}

