/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.ceph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.storage.KVStorage;
import kd.bos.algo.storage.KVStorageCeph;
import kd.bos.algo.storage.ceph.CephStorageServiceSwift;
import kd.bos.algo.storage.ceph.ICephStorageService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;

public class CephStorage
implements KVStorageCeph {
    private int writeFlushThreshold = ConfigurationUtil.getInteger((String)"algo.storage.Ceph.writeFlushThreshold", (Integer)1024000);
    private static final String traceClassKey = "AlgoCephStorage";
    ICephStorageService cservie;

    public CephStorage() {
        try {
            this.cservie = CephStorageServiceSwift.getInstance();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.cephRead, new Object[0]);
        }
    }

    @Override
    public KVStorage.KVWriter create(String id, long timeout) throws IOException {
        return new CephWriter(id, timeout);
    }

    @Override
    public boolean delete(String id) throws IOException {
        try (TraceSpan span = Tracer.create((String)traceClassKey, (String)"delete");){
            span.addTag("id", id);
            boolean bl = this.cservie.deleteBucket(id);
            return bl;
        }
    }

    @Override
    public boolean exists(String id) throws IOException {
        try (TraceSpan span = Tracer.create((String)traceClassKey, (String)"exists");){
            span.addTag("id", id);
            boolean bl = this.cservie.isBucketExists(id);
            return bl;
        }
    }

    @Override
    public CephReader open(String id) throws IOException {
        return new CephReader(id);
    }

    @Override
    public String getName() {
        return "Ceph";
    }

    public class CephReader
    implements KVStorageCeph.KVCephReader {
        private String id;

        public CephReader(String id) {
            this.id = id;
        }

        @Override
        public InputStream get_inputstream(String key) throws IOException {
            return CephStorage.this.cservie.getObject(this.id, key);
        }

        @Override
        public String get_is_Content(String key) throws IOException {
            StringBuilder sb = new StringBuilder();
            try (InputStream in = this.get_inputstream(key);){
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                try {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    throw new KDException((Throwable)e, BosErrorCode.cephRead, new Object[]{"get key:" + key});
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new KDException((Throwable)e, BosErrorCode.cephRead, new Object[0]);
                    }
                }
            }
            return sb.toString();
        }

        @Override
        public byte[] get(String key) throws IOException {
            throw new UnsupportedOperationException("unsupport method");
        }

        @Override
        public List<byte[]> get(String[] keys) throws IOException {
            throw new UnsupportedOperationException("unsupport method");
        }
    }

    private class CephWriter
    implements KVStorage.KVWriter {
        private String id;
        private int size;
        private HashMap<String, byte[]> map = new HashMap();

        public CephWriter(String id, long timeout) {
            this.id = id;
            try {
                if (!CephStorage.this.cservie.isBucketExists(id)) {
                    CephStorage.this.cservie.createBucket(id);
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.cephWrite, new Object[0]);
            }
        }

        @Override
        public void flush() throws IOException {
            if (!this.map.isEmpty()) {
                try (TraceSpan span = Tracer.create((String)CephStorage.traceClassKey, (String)"flush");){
                    span.addTag("id", this.id);
                    try {
                        for (String key : this.map.keySet()) {
                            CephStorage.this.cservie.saveData(this.id, key, this.map.get(key));
                        }
                        this.map.clear();
                        this.size = 0;
                    }
                    catch (Exception e) {
                        throw new KDException((Throwable)e, BosErrorCode.cephWrite, new Object[]{"put key:" + this.id});
                    }
                }
            }
        }

        @Override
        public void put(String key, byte[] value) throws IOException {
            this.size += value.length;
            this.map.put(key, value);
            if (this.size > CephStorage.this.writeFlushThreshold) {
                this.flush();
            }
        }
    }
}

