/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.hbase;

import io.leopard.javahost.JavaHost;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.storage.KVStorage;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;

public class HbaseStorage
implements KVStorage {
    private static final String CONFIGKEY_PREFIX = "algo.storage.hbase.";
    public static final String CONFIGKEY_MASTER = "algo.storage.hbase.master";
    public static final String CONFIGKEY_ZKCLIENTPORT = "algo.storage.hbase.zookeeper.clientPort";
    public static final String CONFIGKEY_ZKQUORUM = "algo.storage.hbase.zookeeper.quorum";
    public static final String CONFIGKEY_JAVAV_VIRTUAL_DNS_ENABLE = "algo.storage.hbase.jvmvdns.enable";
    public static final String CONFIGKEY_JAVAV_VIRTUAL_DNS_LIST = "algo.storage.hbase.jvmvdns.list";
    public static final String CONFIGKEY_HBASE_PRE_TABLE_COUNT = "algo.storage.hbase.pretable.count";
    public static final String CONFIGKEY_THREADMINSIZE = "algo.storage.hbase.threadMinSize";
    public static final String CONFIGKEY_THREADMAXSIZE = "algo.storage.hbase.threadMaxSize";
    private static final int defaultThreadMinSize = 3;
    private static final int defaultThreadMaxSize = 20;
    private static Configuration configuration;
    private static final String HTBALE_NAME = "algods";
    private static final String HTBALE_FAMILY_NAME = "a";
    private static final byte[] family;
    private static Connection con;
    private static int PRE_TABLE_COUNT;
    private static final int DEFALUT_WRITE_FLUSH_THRESHOLD = 1024000;
    private int writeFlushThreshold = ConfigurationUtil.getInteger((String)"algo.storage.hbase.writeFlushThreshold", (Integer)1024000);

    private static void initTable(String tablename, Admin admin) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        TableName tn = TableName.valueOf((String)tablename);
        if (!admin.tableExists(tn)) {
            HTableDescriptor tableDescriptor = new HTableDescriptor(tn);
            tableDescriptor.addFamily(new HColumnDescriptor(HTBALE_FAMILY_NAME));
            admin.createTable(tableDescriptor);
        }
    }

    private static Connection createConnection(Configuration configuration) throws IOException {
        int minSize = 3;
        int maxSize = 20;
        String str = System.getProperty(CONFIGKEY_THREADMINSIZE);
        if (str != null) {
            minSize = Integer.parseInt(str.trim());
        }
        if ((str = System.getProperty(CONFIGKEY_THREADMAXSIZE)) != null) {
            maxSize = Integer.parseInt(CONFIGKEY_THREADMAXSIZE);
        }
        ThreadPoolExecutor es = new ThreadPoolExecutor(minSize, maxSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "hbase-client-" + this.atomicInteger.incrementAndGet());
            }
        });
        return ConnectionFactory.createConnection((Configuration)configuration, (ExecutorService)es);
    }

    private static Map<String, String> praseDnsStr(String lsVirtualdns) {
        String[] paires;
        HashMap<String, String> m = new HashMap<String, String>();
        for (String p : paires = lsVirtualdns.split(",")) {
            String[] pair = p.split(" ");
            if (pair.length != 2) continue;
            m.put(pair[0].trim(), pair[1].trim());
        }
        return m;
    }

    @Override
    public KVStorage.KVWriter create(String id, long timeout) throws IOException {
        return new HbaseWriter(id, timeout);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean delete(String id) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists(String id) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public KVStorage.KVReader open(String id) throws IOException {
        return new HbaseReader(id);
    }

    private byte[] encode(String s) {
        try {
            if (s == null) {
                throw new RuntimeException("value sent to hbase cannot be null");
            }
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private TableName getTableName(String id) {
        return TableName.valueOf((String)this.getTableByID(id));
    }

    private String getTableByID(String id) {
        int h = id.hashCode();
        h ^= h >>> 16;
        int i = h & PRE_TABLE_COUNT - 1;
        return HTBALE_NAME + i;
    }

    @Override
    public String getName() {
        return "hbase";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block18: {
            family = HTBALE_FAMILY_NAME.getBytes();
            PRE_TABLE_COUNT = 128;
            try {
                String hbaseMaster = System.getProperty(CONFIGKEY_MASTER);
                String zkport = System.getProperty(CONFIGKEY_ZKCLIENTPORT);
                String zkquorum = System.getProperty(CONFIGKEY_ZKQUORUM);
                String preTableCstr = System.getProperty(CONFIGKEY_HBASE_PRE_TABLE_COUNT, "128");
                if (zkport == null || zkquorum == null) {
                    throw new KDException(BosErrorCode.hbaseRead, new Object[]{"Not yet config hbase of master/zookeeper.clientPort/zookeeper.quorum"});
                }
                configuration = HBaseConfiguration.create();
                configuration.set("hbase.zookeeper.property.clientPort", zkport);
                configuration.set("hbase.zookeeper.quorum", zkquorum);
                configuration.set("hbase.master", hbaseMaster);
                configuration.setInt("hbase.rpc.timeout", 20000);
                configuration.setInt("hbase.client.operation.timeout", 30000);
                configuration.setInt("hbase.client.scanner.timeout.period", 200000);
                String enableVirtualdns = System.getProperty(CONFIGKEY_JAVAV_VIRTUAL_DNS_ENABLE, "true");
                if ("true".equals(enableVirtualdns)) {
                    String lsVirtualdns = System.getProperty(CONFIGKEY_JAVAV_VIRTUAL_DNS_LIST, "");
                    Map<String, String> m = HbaseStorage.praseDnsStr(lsVirtualdns);
                    Properties props = new Properties();
                    for (Map.Entry<String, String> hostname : m.entrySet()) {
                        String value = hostname.getValue();
                        if (hostname.getKey().length() <= 0 || value.length() <= 0) continue;
                        props.put(hostname.getKey(), value);
                    }
                    JavaHost.updateVirtualDns((Properties)props);
                }
                PRE_TABLE_COUNT = Integer.valueOf(preTableCstr);
            }
            catch (Exception e) {
                if (!(e instanceof KDException)) break block18;
                throw e;
            }
        }
        Admin admin = null;
        try {
            con = HbaseStorage.createConnection(configuration);
            admin = con.getAdmin();
            for (int i = 0; i < PRE_TABLE_COUNT; ++i) {
                HbaseStorage.initTable(HTBALE_NAME + i, admin);
            }
        }
        catch (Throwable e) {
            System.setProperty("algo.storage.datasetcache.type", "redis");
            System.setProperty("hbase_error", "not init hbase");
        }
        finally {
            if (admin != null) {
                try {
                    admin.close();
                }
                catch (Exception i) {}
            }
        }
    }

    private class HbaseWriter
    implements KVStorage.KVWriter {
        private String id;
        private int size;
        private HashMap<byte[], byte[]> map = new HashMap();
        private long timeout;

        public HbaseWriter(String id, long timeout) {
            this.id = id;
            this.timeout = timeout;
        }

        @Override
        public void flush() throws IOException {
            if (!this.map.isEmpty()) {
                try (TraceSpan span = Tracer.create((String)"AlgoHbaseStorage", (String)"flush");){
                    span.addTag("id", this.id);
                    byte[] idByte = HbaseStorage.this.encode(this.id);
                    Table htable = null;
                    try {
                        Put put = new Put(idByte);
                        for (byte[] key : this.map.keySet()) {
                            put.addColumn(family, key, this.map.get(key));
                        }
                        put.setTTL(this.timeout);
                        htable = con.getTable(HbaseStorage.this.getTableName(this.id));
                        htable.put(put);
                        this.map.clear();
                        this.size = 0;
                    }
                    catch (Exception e) {
                        throw new KDException((Throwable)e, BosErrorCode.hbaseRead, new Object[]{"put key:" + this.id});
                    }
                    finally {
                        if (null != htable) {
                            try {
                                htable.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }
        }

        @Override
        public void put(String key, byte[] value) throws IOException {
            this.size += value.length;
            this.map.put(HbaseStorage.this.encode(key), value);
            if (this.size > HbaseStorage.this.writeFlushThreshold) {
                this.flush();
            }
        }
    }

    private class HbaseReader
    implements KVStorage.KVReader {
        private String id;

        public HbaseReader(String id) {
            this.id = id;
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] get(String key) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        public List<byte[]> get(String[] keys) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

