/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.algo.storage.FileSystemStorage;

public class LocalStorage
implements FileSystemStorage {
    private static String configKeyPrefix = "algo.storage.local.";
    private String baseFilePath = null;

    public LocalStorage() {
        File baseFile;
        String baseFilePath = System.getProperty(configKeyPrefix + "path");
        if (baseFilePath == null) {
            baseFilePath = System.getProperty("java.io.tmpdir").replace('\\', '/') + "datasetcache";
        }
        if ((baseFile = new File(baseFilePath)).exists()) {
            baseFile.delete();
        }
        baseFile.mkdirs();
    }

    @Override
    public boolean createDirectory(String url, long timeout) throws IOException {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(fullPath);
        boolean r = file.mkdirs();
        file.deleteOnExit();
        return r;
    }

    @Override
    public OutputStream create(String url, long timeout) throws IOException {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(fullPath);
        file.getParentFile().mkdirs();
        file.deleteOnExit();
        return new FileOutputStream(file);
    }

    @Override
    public InputStream open(String url) throws IOException {
        String fullPath = this.baseFilePath + "/" + url;
        return new FileInputStream(fullPath);
    }

    @Override
    public boolean exists(String url) {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(fullPath);
        return file.exists();
    }

    @Override
    public boolean delete(String url) {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(fullPath);
        return this.delete(file);
    }

    private boolean delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        return file.delete();
    }

    @Override
    public String getName() {
        return "localfile";
    }
}

