/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.util.DiskCacheUtils;

public class LocalStorage3
implements FileSystemStorage {
    @Override
    public boolean createDirectory(String url, long timeout) throws IOException {
        return true;
    }

    @Override
    public OutputStream create(String url, long timeout) throws IOException {
        return DiskCacheUtils.cacheOutputStream((String)this.getCacheKey(url), (int)((int)(timeout / 1000L)));
    }

    @Override
    public InputStream open(String url) throws IOException {
        return DiskCacheUtils.getData((String)this.getCacheKey(url));
    }

    @Override
    public boolean exists(String url) throws IOException {
        return DiskCacheUtils.exists((String)this.getCacheKey(url));
    }

    @Override
    public boolean delete(String url) throws IOException {
        return DiskCacheUtils.removeSamePrefixKeys((String)this.getCacheKey(url));
    }

    @Override
    public String getName() {
        return "localfile";
    }

    private String getCacheKey(String url) {
        return url.replaceAll("/", "_").replaceAll("/", "_");
    }
}

