/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.streamsource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.streamsource.StreamSource;

public class ResultSetStreamSource
extends StreamSource {
    private RowMeta rowMeta;
    private ResultSet rs;
    private InnerRowIterator innerRowIterator;

    public ResultSetStreamSource(ResultSet rs) {
        this.rs = rs;
        this.type = "ResultSet";
        this.rowMeta = this.initRowMeta(rs);
    }

    public ResultSetStreamSource(ResultSet rs, RowMeta rowMeta) {
        this.rs = rs;
        this.rowMeta = rowMeta;
    }

    private RowMeta initRowMeta(ResultSet rs) {
        return RowMeta.fromResultSet(rs);
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator rowIterator() {
        if (this.innerRowIterator == null) {
            this.innerRowIterator = this.convertIterator();
        }
        return this.innerRowIterator;
    }

    public InnerRowIterator convertIterator() {
        return new InnerRowIterator(){
            boolean nexted = false;
            boolean hasNext = false;

            @Override
            public boolean _hasNext() {
                if (!this.nexted) {
                    this.doNext();
                }
                return this.hasNext;
            }

            private void doNext() {
                this.nexted = true;
                try {
                    this.hasNext = ResultSetStreamSource.this.rs.next();
                }
                catch (SQLException e) {
                    throw new AlgoException(e);
                }
            }

            @Override
            public Row _next() {
                try {
                    if (!this.nexted) {
                        this.doNext();
                    }
                    if (!this.hasNext) {
                        throw new AlgoException("EOF");
                    }
                    Row row = RowFactory.createRow(ResultSetStreamSource.this.rowMeta, ResultSetStreamSource.this.rs);
                    return row;
                }
                finally {
                    this.nexted = false;
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                Statement stmt = this.rs.getStatement();
                try {
                    this.rs.close();
                    this.rs = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

