/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.AvgValue;

public class AggUtil {
    public static BigDecimal toBigDecimal(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return new BigDecimal(v.toString());
    }

    public static Object add(Object sum, Object value) throws AlgoException {
        if (sum != null && sum instanceof AvgValue) {
            sum = ((AvgValue)sum).getAvgValue();
        }
        if (value != null && value instanceof AvgValue) {
            value = ((AvgValue)value).getAvgValue();
        }
        if (value == null) {
            return sum;
        }
        if (sum == null) {
            return value;
        }
        if (sum instanceof Number && value instanceof Number) {
            if (sum instanceof BigDecimal || value instanceof BigDecimal) {
                return AggUtil.toBigDecimal(sum).add(AggUtil.toBigDecimal(value));
            }
            if (sum instanceof Double || value instanceof Double || sum instanceof Float || value instanceof Float) {
                return ((Number)sum).doubleValue() + ((Number)value).doubleValue();
            }
            if (sum instanceof Long || value instanceof Long) {
                return ((Number)sum).longValue() + ((Number)value).longValue();
            }
            return ((Number)sum).intValue() + ((Number)value).intValue();
        }
        throw new AlgoException("Can't add " + sum.toString() + " + " + value.toString());
    }

    public static int compare(Object v1, Object v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1 instanceof String) {
            return ((String)v1).compareTo((String)v2);
        }
        if (v1 instanceof Date) {
            return ((Date)v1).compareTo((Date)v2);
        }
        if (v1 instanceof Long) {
            return ((Long)v1).compareTo((Long)v2);
        }
        if (v1 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2);
        }
        if (v1 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2);
        }
        if (v1 instanceof BigInteger) {
            return ((BigInteger)v1).compareTo((BigInteger)v2);
        }
        if (v1 instanceof Number) {
            int i2;
            int i1 = ((Number)v1).intValue();
            if (i1 > (i2 = ((Number)v2).intValue())) {
                return 1;
            }
            if (i1 < i2) {
                return -1;
            }
            return 0;
        }
        return 0;
    }
}

