/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.Aggregators;

public abstract class Aggregator
implements Serializable {
    public static final long serialVersionUID = 4576365898477547547L;
    public static final String SUM = "sum";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String AVG = "avg";
    public static final String COUNT = "count";
    public static final String FIRST = "first";
    public static final String LAST = "last";
    public static final String SUMIF = "sumif";
    public static final String MAXIF = "maxif";
    public static final String MINIF = "minif";
    public static final String AVGIF = "avgif";
    public static final String COUNTIF = "countif";
    public static final String MAXP = "maxP";
    public static final String MINP = "minP";
    private static final HashMap<String, Aggregator> aggregators = new HashMap();
    public final String name;

    public static void registerAggregator(Aggregator x) {
        aggregators.put(x.name.toLowerCase(), x);
    }

    public static boolean isAggregator(String name) {
        return aggregators.get(name.toLowerCase()) != null;
    }

    public static Aggregator getAggregator(String name) throws AlgoException {
        Aggregator x = aggregators.get(name.toLowerCase());
        if (x == null) {
            throw new AlgoException("Aggregator '" + name + "' not found.");
        }
        return x;
    }

    public Aggregator(String _name) {
        this.name = _name;
    }

    public abstract Object appendValue(Object var1, Object var2) throws AlgoException;

    public abstract Object appendAggregator(Object var1, Object var2) throws AlgoException;

    public abstract Object getValue(Object var1) throws AlgoException;

    public abstract boolean valueIsCompounded();

    public ValueSerializable getSerialize() {
        return null;
    }

    static {
        Aggregators.register();
    }

    public static interface ValueSerializable {
        public Object deserialize(int var1, DataInput var2) throws IOException, ClassNotFoundException;

        public void serialize(Object var1, int var2, DataOutput var3) throws IOException;
    }
}

