/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.io.Serializable;

public abstract class KeyIntMap
implements Serializable {
    private static final long serialVersionUID = -7133347898197692075L;
    public static final int NOT_PRESENT = -1;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x100000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    int _readOnlyMapSize;
    int _size;
    int _capacity;
    int _threshold;
    final float _loadFactor;

    public KeyIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity " + initialCapacity);
        }
        if (initialCapacity > 0x100000) {
            initialCapacity = 0x100000;
        }
        if (loadFactor > 0.0f && !Float.isNaN(loadFactor)) {
            if (initialCapacity != 16) {
                this._capacity = 1;
                while (this._capacity < initialCapacity) {
                    this._capacity <<= 1;
                }
                this._loadFactor = loadFactor;
                this._threshold = (int)((float)this._capacity * this._loadFactor);
            } else {
                this._capacity = 16;
                this._loadFactor = 0.75f;
                this._threshold = 12;
            }
        } else {
            throw new IllegalArgumentException("illegal LoadFactor " + loadFactor);
        }
    }

    public KeyIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public KeyIntMap() {
        this._capacity = 16;
        this._loadFactor = 0.75f;
        this._threshold = 12;
    }

    public final int size() {
        return this._size + this._readOnlyMapSize;
    }

    public abstract void clear();

    public abstract void setReadOnlyMap(KeyIntMap var1, boolean var2);

    public static final int hashHash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public static final int indexFor(int h, int length) {
        return h & length - 1;
    }

    static class BaseEntry
    implements Serializable {
        private static final long serialVersionUID = -271875426124026958L;
        final int _hash;
        final int _value;

        public BaseEntry(int hash, int value) {
            this._hash = hash;
            this._value = value;
        }
    }
}

