/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.sort;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import kd.bos.algo.util.sort.ComparableX;
import kd.bos.algo.util.sort.Sorter;

public class ForkJoinSorter
extends Sorter {
    private static final ForkJoinPool threadPool = new ForkJoinPool();
    private static final int THRESHOLD = 16;

    public ForkJoinSorter(ComparableX comparator) {
        super(comparator);
    }

    public ForkJoinSorter(ComparableX[] comparators) {
        super(comparators);
    }

    @Override
    public void sort(int[] values) {
        if (values.length <= 16) {
            this.insertionSort(values, 0, values.length - 1);
            return;
        }
        int[] temp = new int[values.length];
        threadPool.invoke(new SortTask(values, temp, 0, values.length - 1));
    }

    private void insertionSort(int[] a, int startPos, int endPos) {
        for (int i = startPos + 1; i <= endPos; ++i) {
            int j;
            int t = a[j];
            for (j = i; j > startPos && this.compare(t, a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = t;
        }
    }

    private class SortTask
    extends RecursiveAction {
        int[] a;
        int[] temp;
        int startPos;
        int endPos;

        private SortTask(int[] a, int[] temp, int startPos, int endPos) {
            this.a = a;
            this.startPos = startPos;
            this.endPos = endPos;
            this.temp = temp;
        }

        @Override
        protected void compute() {
            if (this.endPos - this.startPos < 16) {
                ForkJoinSorter.this.insertionSort(this.a, this.startPos, this.endPos);
                return;
            }
            int m = (this.startPos + this.endPos) / 2;
            SortTask.invokeAll(new SortTask(this.a, this.temp, this.startPos, m), new SortTask(this.a, this.temp, m + 1, this.endPos));
            this.merge(this.a, this.temp, this.startPos, m, this.endPos);
        }

        private void merge(int[] a, int[] b, int startPos, int m, int endPos) {
            if (ForkJoinSorter.this.compare(a[m], a[m + 1]) <= 0) {
                return;
            }
            System.arraycopy(a, startPos, b, startPos, m - startPos + 1);
            int i = startPos;
            int j = m + 1;
            int k = startPos;
            while (k < j && j <= endPos) {
                if (ForkJoinSorter.this.compare(b[i], a[j]) <= 0) {
                    a[k++] = b[i++];
                    continue;
                }
                a[k++] = a[j++];
            }
            System.arraycopy(b, i, a, k, j - k);
        }
    }
}

