/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.sort;

import kd.bos.algo.util.sort.ComparableX;
import kd.bos.algo.util.sort.Sorter;

public class QuickSorter3
extends Sorter {
    public QuickSorter3(ComparableX[] comparators) {
        super(comparators);
    }

    public QuickSorter3(ComparableX comparator) {
        super(comparator);
    }

    @Override
    public void sort(int[] a) {
        this.sort(a, 0, a.length - 1);
    }

    public void sort(int[] a, int lo, int hi) {
        if (lo >= hi) {
            return;
        }
        int pivot = this.partition(a, lo, hi);
        this.sort(a, lo, pivot - 1);
        this.sort(a, pivot + 1, hi);
    }

    private int partition(int[] a, int lo, int hi) {
        int pivot = lo + (hi - lo) / 2;
        this.swap(a, pivot, hi);
        int storeIndex = lo;
        for (int i = lo; i < hi; ++i) {
            if (this.compare(a[i], a[hi]) >= 0) continue;
            this.swap(a, storeIndex, i);
            ++storeIndex;
        }
        this.swap(a, hi, storeIndex);
        return storeIndex;
    }

    private void swap(int[] a, int i, int j) {
        int temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }
}

