/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox;

import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;

public abstract class InputExecutor<I extends Input> {
    protected I input;
    protected RowMeta rowMeta;
    protected DataType[] dataTypes;

    public InputExecutor(I input, RowMeta rowMeta) {
        this.input = input;
        this.rowMeta = rowMeta;
        if (rowMeta != null) {
            this.dataTypes = rowMeta.getDataTypes();
        }
    }

    public abstract void open();

    public abstract RowX next(RowX var1);

    public abstract boolean hasNext();

    public abstract void close();

    public void convertToRowX(RowX out, Row row) {
        if (this.dataTypes == null) {
            for (int pos = 0; pos < out.size(); ++pos) {
                out.set(pos, row.get(pos));
            }
        } else {
            for (int pos = 0; pos < out.size(); ++pos) {
                out.set(pos, DataType.convertValue(this.dataTypes[pos], row.get(pos)));
            }
        }
    }
}

