/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox;

import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algox.AlgoXException;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.cluster.ClusterFactory;
import kd.bos.algox.core.DataSourceX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.datachannel.DataChannels;
import kd.bos.algox.jobman.JobMan;

public class JobSession {
    private JobContext context = new JobContext();

    JobSession() {
    }

    JobSession(String jobName) {
        this.context.setJobName(jobName);
    }

    public void disableLocalModel() {
        this.context.disableLocalModel();
    }

    public DataSetX fromInput(Input input) {
        return new DataSourceX(this.context, input);
    }

    public DataSetX fromInput(Input ... inputs) {
        if (inputs.length == 0) {
            throw new AlgoXException("Inputs is empty.");
        }
        return new DataSourceX(this.context, inputs);
    }

    public void commit(int timeout, TimeUnit timeUnit) throws CommitTimeoutException, RunningTimeoutException {
        this.commit(timeout, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int commitTimeout, int runningTimeout, TimeUnit timeUnit) throws CommitTimeoutException, RunningTimeoutException {
        try {
            ClusterClient cluster = ClusterFactory.getFactory().getClusterClient();
            Object jobId = cluster.submitJob(this.context, (int)timeUnit.toSeconds(commitTimeout));
            long ms = timeUnit.toMillis(runningTimeout);
            JobMan.syncWaitJob(jobId, ms);
        }
        finally {
            this.context.clear();
        }
    }

    public JobContext getContext() {
        return this.context;
    }

    public DataSet readDataSet(String id) {
        return DataChannels.readDataSet("algox", id);
    }

    public String toDataSetCacheId(String id) {
        return DataChannels.toDataSetCacheId(id);
    }
}

